/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis.compound;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.compound.HyphenationCompoundWordTokenFilter;
import org.apache.lucene.analysis.compound.Lucene43HyphenationCompoundWordTokenFilter;
import org.apache.lucene.analysis.compound.hyphenation.HyphenationTree;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AnalysisSettingsRequired;
import org.elasticsearch.index.analysis.compound.AbstractCompoundWordTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.xml.sax.InputSource;

@AnalysisSettingsRequired
public class HyphenationCompoundWordTokenFilterFactory
extends AbstractCompoundWordTokenFilterFactory {
    private final HyphenationTree hyphenationTree;

    @Inject
    public HyphenationCompoundWordTokenFilterFactory(Index index, IndexSettingsService indexSettingsService, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettingsService.getSettings(), env, name, settings);
        String hyphenationPatternsPath = settings.get("hyphenation_patterns_path", null);
        if (hyphenationPatternsPath == null) {
            throw new IllegalArgumentException("hyphenation_patterns_path is a required setting.");
        }
        Path hyphenationPatternsFile = env.configFile().resolve(hyphenationPatternsPath);
        try {
            this.hyphenationTree = HyphenationCompoundWordTokenFilter.getHyphenationTree((InputSource)new InputSource(Files.newInputStream(hyphenationPatternsFile, new OpenOption[0])));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Exception while reading hyphenation_patterns_path: " + e.getMessage());
        }
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        if (this.version.onOrAfter(Version.LUCENE_4_4_0)) {
            return new HyphenationCompoundWordTokenFilter(tokenStream, this.hyphenationTree, this.wordList, this.minWordSize, this.minSubwordSize, this.maxSubwordSize, this.onlyLongestMatch);
        }
        return new Lucene43HyphenationCompoundWordTokenFilter(tokenStream, this.hyphenationTree, this.wordList, this.minWordSize, this.minSubwordSize, this.maxSubwordSize, this.onlyLongestMatch);
    }
}

