/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import com.google.common.base.Joiner;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsAbortPolicy;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.PrioritizedEsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.SizeBlockingQueue;
import org.elasticsearch.common.util.concurrent.XRejectedExecutionHandler;

public class EsExecutors {
    public static final String PROCESSORS = "processors";
    public static final String DEFAULT_SYSPROP = "es.processors.override";

    public static int boundedNumberOfProcessors(Settings settings) {
        int defaultValue = Math.min(32, Runtime.getRuntime().availableProcessors());
        try {
            defaultValue = Integer.parseInt(System.getProperty(DEFAULT_SYSPROP));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return settings.getAsInt(PROCESSORS, (Integer)defaultValue);
    }

    public static PrioritizedEsThreadPoolExecutor newSinglePrioritizing(String name, ThreadFactory threadFactory) {
        return new PrioritizedEsThreadPoolExecutor(name, 1, 1, 0L, TimeUnit.MILLISECONDS, threadFactory);
    }

    public static EsThreadPoolExecutor newScaling(String name, int min, int max, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        ExecutorScalingQueue<Runnable> queue = new ExecutorScalingQueue<Runnable>();
        EsThreadPoolExecutor executor = new EsThreadPoolExecutor(name, min, max, keepAliveTime, unit, queue, threadFactory, new ForceQueuePolicy());
        queue.executor = executor;
        return executor;
    }

    public static EsThreadPoolExecutor newCached(String name, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        return new EsThreadPoolExecutor(name, 0, Integer.MAX_VALUE, keepAliveTime, unit, new SynchronousQueue<Runnable>(), threadFactory, new EsAbortPolicy());
    }

    public static EsThreadPoolExecutor newFixed(String name, int size, int queueCapacity, ThreadFactory threadFactory) {
        BlockingQueue<Runnable> queue = queueCapacity < 0 ? ConcurrentCollections.newBlockingQueue() : new SizeBlockingQueue(ConcurrentCollections.newBlockingQueue(), queueCapacity);
        return new EsThreadPoolExecutor(name, size, size, 0L, TimeUnit.MILLISECONDS, queue, threadFactory, new EsAbortPolicy());
    }

    public static String threadName(Settings settings, String ... names) {
        return EsExecutors.threadName(settings, "[" + Joiner.on((String)".").skipNulls().join((Object[])names) + "]");
    }

    public static String threadName(Settings settings, String namePrefix) {
        String name = settings.get("name");
        name = name == null ? "elasticsearch" : "elasticsearch[" + name + "]";
        return name + "[" + namePrefix + "]";
    }

    public static ThreadFactory daemonThreadFactory(Settings settings, String namePrefix) {
        return EsExecutors.daemonThreadFactory(EsExecutors.threadName(settings, namePrefix));
    }

    public static ThreadFactory daemonThreadFactory(Settings settings, String ... names) {
        return EsExecutors.daemonThreadFactory(EsExecutors.threadName(settings, names));
    }

    public static ThreadFactory daemonThreadFactory(String namePrefix) {
        return new EsThreadFactory(namePrefix);
    }

    private EsExecutors() {
    }

    static class ForceQueuePolicy
    implements XRejectedExecutionHandler {
        ForceQueuePolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                throw new EsRejectedExecutionException(e);
            }
        }

        @Override
        public long rejected() {
            return 0L;
        }
    }

    static class ExecutorScalingQueue<E>
    extends LinkedTransferQueue<E> {
        ThreadPoolExecutor executor;

        @Override
        public boolean offer(E e) {
            if (!this.tryTransfer(e)) {
                int left = this.executor.getMaximumPoolSize() - this.executor.getCorePoolSize();
                if (left > 0) {
                    return false;
                }
                return super.offer(e);
            }
            return true;
        }
    }

    static class EsThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        public EsThreadFactory(String namePrefix) {
            this.namePrefix = namePrefix;
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + "[T#" + this.threadNumber.getAndIncrement() + "]", 0L);
            t.setDaemon(true);
            return t;
        }
    }
}

