/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.analyze;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.analyze.DetailAnalyzeResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class AnalyzeResponse
extends ActionResponse
implements Iterable<AnalyzeToken>,
ToXContent {
    private DetailAnalyzeResponse detail;
    private List<AnalyzeToken> tokens;

    AnalyzeResponse() {
    }

    public AnalyzeResponse(List<AnalyzeToken> tokens, DetailAnalyzeResponse detail) {
        this.tokens = tokens;
        this.detail = detail;
    }

    public List<AnalyzeToken> getTokens() {
        return this.tokens;
    }

    public DetailAnalyzeResponse detail() {
        return this.detail;
    }

    @Override
    public Iterator<AnalyzeToken> iterator() {
        return this.tokens.iterator();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.tokens != null) {
            builder.startArray(Fields.TOKENS);
            for (AnalyzeToken token : this.tokens) {
                token.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.detail != null) {
            builder.startObject(Fields.DETAIL);
            this.detail.toXContent(builder, params);
            builder.endObject();
        }
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.tokens = new ArrayList<AnalyzeToken>(size);
        for (int i = 0; i < size; ++i) {
            this.tokens.add(AnalyzeToken.readAnalyzeToken(in));
        }
        if (in.getVersion().onOrAfter(Version.V_2_2_0)) {
            this.detail = in.readOptionalStreamable(new DetailAnalyzeResponse());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.tokens != null) {
            out.writeVInt(this.tokens.size());
            for (AnalyzeToken token : this.tokens) {
                token.writeTo(out);
            }
        } else {
            out.writeVInt(0);
        }
        if (out.getVersion().onOrAfter(Version.V_2_2_0)) {
            out.writeOptionalStreamable(this.detail);
        }
    }

    static final class Fields {
        static final XContentBuilderString TOKENS = new XContentBuilderString("tokens");
        static final XContentBuilderString TOKEN = new XContentBuilderString("token");
        static final XContentBuilderString START_OFFSET = new XContentBuilderString("start_offset");
        static final XContentBuilderString END_OFFSET = new XContentBuilderString("end_offset");
        static final XContentBuilderString TYPE = new XContentBuilderString("type");
        static final XContentBuilderString POSITION = new XContentBuilderString("position");
        static final XContentBuilderString DETAIL = new XContentBuilderString("detail");

        Fields() {
        }
    }

    public static class AnalyzeToken
    implements Streamable,
    ToXContent {
        private String term;
        private int startOffset;
        private int endOffset;
        private int position;
        private Map<String, Object> attributes;
        private String type;

        AnalyzeToken() {
        }

        public AnalyzeToken(String term, int position, int startOffset, int endOffset, String type, Map<String, Object> attributes) {
            this.term = term;
            this.position = position;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.type = type;
            this.attributes = attributes;
        }

        public String getTerm() {
            return this.term;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public int getPosition() {
            return this.position;
        }

        public String getType() {
            return this.type;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Fields.TOKEN, this.term);
            builder.field(Fields.START_OFFSET, this.startOffset);
            builder.field(Fields.END_OFFSET, this.endOffset);
            builder.field(Fields.TYPE, this.type);
            builder.field(Fields.POSITION, this.position);
            if (this.attributes != null && !this.attributes.isEmpty()) {
                for (Map.Entry<String, Object> entity : this.attributes.entrySet()) {
                    builder.field(entity.getKey(), entity.getValue());
                }
            }
            builder.endObject();
            return builder;
        }

        public static AnalyzeToken readAnalyzeToken(StreamInput in) throws IOException {
            AnalyzeToken analyzeToken = new AnalyzeToken();
            analyzeToken.readFrom(in);
            return analyzeToken;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.term = in.readString();
            this.startOffset = in.readInt();
            this.endOffset = in.readInt();
            this.position = in.readVInt();
            this.type = in.readOptionalString();
            if (in.getVersion().onOrAfter(Version.V_2_2_0)) {
                this.attributes = (Map)in.readGenericValue();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.term);
            out.writeInt(this.startOffset);
            out.writeInt(this.endOffset);
            out.writeVInt(this.position);
            out.writeOptionalString(this.type);
            if (out.getVersion().onOrAfter(Version.V_2_2_0)) {
                out.writeGenericValue(this.attributes);
            }
        }
    }
}

