/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.rubypeople.rdt.internal.launching.ArgumentSplitter;
import org.rubypeople.rdt.internal.launching.IllegalCommandException;
import org.rubypeople.rdt.internal.launching.InterpreterRunnerConfiguration;
import org.rubypeople.rdt.internal.launching.RdtLaunchingPlugin;
import org.rubypeople.rdt.internal.launching.RubyInterpreter;

public class InterpreterRunner {
    public IProcess run(InterpreterRunnerConfiguration interpreterRunnerConfiguration, ILaunch iLaunch) throws CoreException {
        List list = this.renderCommandLine(interpreterRunnerConfiguration);
        File file = interpreterRunnerConfiguration.getAbsoluteWorkingDirectory();
        RubyInterpreter rubyInterpreter = interpreterRunnerConfiguration.getInterpreter();
        Process process = rubyInterpreter.exec(list, file);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(IProcess.ATTR_PROCESS_TYPE, "ruby");
        IProcess iProcess = DebugPlugin.newProcess((ILaunch)iLaunch, (Process)process, (String)this.renderLabel(interpreterRunnerConfiguration), hashMap);
        iProcess.setAttribute("org.rubypeople.rdt.launching.launcher.cmdline", list.toString());
        return iProcess;
    }

    protected String renderLabel(InterpreterRunnerConfiguration interpreterRunnerConfiguration) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            RubyInterpreter rubyInterpreter = interpreterRunnerConfiguration.getInterpreter();
            stringBuffer.append("Ruby ");
            stringBuffer.append(rubyInterpreter.getCommand());
            stringBuffer.append(" : ");
            stringBuffer.append(interpreterRunnerConfiguration.getFileName());
        }
        catch (IllegalCommandException illegalCommandException) {}
        return stringBuffer.toString();
    }

    private List renderCommandLine(InterpreterRunnerConfiguration interpreterRunnerConfiguration) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.addDebugCommandLineArgument(arrayList);
        arrayList.addAll(interpreterRunnerConfiguration.renderLoadPath());
        arrayList.addAll(ArgumentSplitter.split(interpreterRunnerConfiguration.getInterpreterArguments()));
        arrayList.add("--");
        arrayList.add(RdtLaunchingPlugin.osDependentPath(interpreterRunnerConfiguration.getAbsoluteFileName()));
        arrayList.addAll(ArgumentSplitter.split(interpreterRunnerConfiguration.getProgramArguments()));
        return arrayList;
    }

    protected void addDebugCommandLineArgument(List list) {
    }
}

