/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.viewsupport;

import java.util.ArrayList;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.rubypeople.rdt.internal.ui.viewsupport.RubyElementImageProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.StorageLabelProvider;
import org.rubypeople.rdt.ui.RubyElementLabels;

public class RubyUILabelProvider
implements ILabelProvider,
IColorProvider {
    protected ListenerList fListeners = new ListenerList(1);
    protected RubyElementImageProvider fImageLabelProvider = new RubyElementImageProvider();
    protected StorageLabelProvider fStorageLabelProvider = new StorageLabelProvider();
    private ArrayList fLabelDecorators = null;
    private int fImageFlags;
    private long fTextFlags;

    public RubyUILabelProvider() {
        this(RubyElementLabels.ALL_DEFAULT, 1);
    }

    public RubyUILabelProvider(long l, int n) {
        this.fImageFlags = n;
        this.fTextFlags = l;
    }

    public void addLabelDecorator(ILabelDecorator iLabelDecorator) {
        if (this.fLabelDecorators == null) {
            this.fLabelDecorators = new ArrayList(2);
        }
        this.fLabelDecorators.add(iLabelDecorator);
    }

    public final void setTextFlags(long l) {
        this.fTextFlags = l;
    }

    public final void setImageFlags(int n) {
        this.fImageFlags = n;
    }

    public final int getImageFlags() {
        return this.fImageFlags;
    }

    public final long getTextFlags() {
        return this.fTextFlags;
    }

    protected int evaluateImageFlags(Object object) {
        return this.getImageFlags();
    }

    protected long evaluateTextFlags(Object object) {
        return this.getTextFlags();
    }

    protected Image decorateImage(Image image, Object object) {
        if (this.fLabelDecorators != null && image != null) {
            int n = 0;
            while (n < this.fLabelDecorators.size()) {
                ILabelDecorator iLabelDecorator = (ILabelDecorator)this.fLabelDecorators.get(n);
                image = iLabelDecorator.decorateImage(image, object);
                ++n;
            }
        }
        return image;
    }

    public Image getImage(Object object) {
        Image image = this.fImageLabelProvider.getImageLabel(object, this.evaluateImageFlags(object));
        if (image == null && object instanceof IStorage) {
            image = this.fStorageLabelProvider.getImage(object);
        }
        return this.decorateImage(image, object);
    }

    protected String decorateText(String string, Object object) {
        if (this.fLabelDecorators != null && string.length() > 0) {
            int n = 0;
            while (n < this.fLabelDecorators.size()) {
                ILabelDecorator iLabelDecorator = (ILabelDecorator)this.fLabelDecorators.get(n);
                string = iLabelDecorator.decorateText(string, object);
                ++n;
            }
        }
        return string;
    }

    public String getText(Object object) {
        String string = RubyElementLabels.getTextLabel(object, this.evaluateTextFlags(object));
        if (string.length() == 0 && object instanceof IStorage) {
            string = this.fStorageLabelProvider.getText(object);
        }
        return this.decorateText(string, object);
    }

    public void dispose() {
        if (this.fLabelDecorators != null) {
            int n = 0;
            while (n < this.fLabelDecorators.size()) {
                ILabelDecorator iLabelDecorator = (ILabelDecorator)this.fLabelDecorators.get(n);
                iLabelDecorator.dispose();
                ++n;
            }
            this.fLabelDecorators = null;
        }
        this.fStorageLabelProvider.dispose();
        this.fImageLabelProvider.dispose();
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
        if (this.fLabelDecorators != null) {
            int n = 0;
            while (n < this.fLabelDecorators.size()) {
                ILabelDecorator iLabelDecorator = (ILabelDecorator)this.fLabelDecorators.get(n);
                iLabelDecorator.addListener(iLabelProviderListener);
                ++n;
            }
        }
        this.fListeners.add((Object)iLabelProviderListener);
    }

    public boolean isLabelProperty(Object object, String string) {
        return true;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        if (this.fLabelDecorators != null) {
            int n = 0;
            while (n < this.fLabelDecorators.size()) {
                ILabelDecorator iLabelDecorator = (ILabelDecorator)this.fLabelDecorators.get(n);
                iLabelDecorator.removeListener(iLabelProviderListener);
                ++n;
            }
        }
        this.fListeners.remove((Object)iLabelProviderListener);
    }

    public static ILabelDecorator[] getDecorators(boolean bl, ILabelDecorator iLabelDecorator) {
        if (bl) {
            if (iLabelDecorator == null) {
                return new ILabelDecorator[0];
            }
            return new ILabelDecorator[]{iLabelDecorator};
        }
        if (iLabelDecorator != null) {
            return new ILabelDecorator[]{iLabelDecorator};
        }
        return null;
    }

    public Color getForeground(Object object) {
        return null;
    }

    public Color getBackground(Object object) {
        return null;
    }

    protected void fireLabelProviderChanged(final LabelProviderChangedEvent labelProviderChangedEvent) {
        Object[] objectArray = this.fListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final ILabelProviderListener iLabelProviderListener = (ILabelProviderListener)objectArray[n];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iLabelProviderListener.labelProviderChanged(labelProviderChangedEvent);
                }
            });
            ++n;
        }
    }
}

