/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.core.formatter;

import java.util.Map;
import org.eclipse.jface.text.Assert;

public class Indents {
    private Indents() {
    }

    public static int getTabWidth(Map map) {
        if (map == null) {
            throw new IllegalArgumentException();
        }
        return Indents.getIntValue(map, "org.rubypeople.rdt.core.formatter.tabulation.size", 4);
    }

    public static int getIndentWidth(Map map) {
        if (map == null) {
            throw new IllegalArgumentException();
        }
        int n = Indents.getTabWidth(map);
        boolean bl = "mixed".equals(map.get("org.rubypeople.rdt.core.formatter.tabulation.char"));
        if (bl) {
            return Indents.getIntValue(map, "org.rubypeople.rdt.core.formatter.indentation.size", n);
        }
        return n;
    }

    private static int getIntValue(Map map, String string, int n) {
        try {
            return Integer.parseInt((String)map.get(string));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static int measureIndentUnits(CharSequence charSequence, int n, int n2) {
        if (n2 <= 0 || n < 0 || charSequence == null) {
            throw new IllegalArgumentException();
        }
        int n3 = Indents.measureIndentInSpaces(charSequence, n);
        return n3 / n2;
    }

    public static String createIndentString(int n, Map map) {
        int n2;
        int n3;
        int n4;
        if (map == null || n < 0) {
            throw new IllegalArgumentException();
        }
        String string = Indents.getStringValue(map, "org.rubypeople.rdt.core.formatter.tabulation.char", "tab");
        if ("space".equals(string)) {
            n4 = 0;
            n3 = n * Indents.getIndentWidth(map);
        } else if ("tab".equals(string)) {
            n4 = n;
            n3 = 0;
        } else if ("mixed".equals(string)) {
            int n5 = Indents.getTabWidth(map);
            n2 = n * Indents.getIndentWidth(map);
            if (n5 > 0) {
                n4 = n2 / n5;
                n3 = n2 % n5;
            } else {
                n4 = 0;
                n3 = n2;
            }
        } else {
            Assert.isTrue((boolean)false);
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(n4 + n3);
        n2 = 0;
        while (n2 < n4) {
            stringBuffer.append('\t');
            ++n2;
        }
        n2 = 0;
        while (n2 < n3) {
            stringBuffer.append(' ');
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String createFixIndentString(int n, Map map) {
        int n2;
        int n3;
        int n4;
        if (map == null || n < 0) {
            throw new IllegalArgumentException();
        }
        String string = Indents.getStringValue(map, "org.rubypeople.rdt.core.formatter.tabulation.char", "tab");
        if ("space".equals(string)) {
            n4 = 0;
            n3 = n;
        } else if ("tab".equals(string)) {
            n2 = Indents.getTabWidth(map);
            n4 = n / n2;
            n3 = 0;
        } else if ("mixed".equals(string)) {
            n2 = Indents.getTabWidth(map);
            if (n2 > 0) {
                n4 = n / n2;
                n3 = n % n2;
            } else {
                n4 = 0;
                n3 = n;
            }
        } else {
            Assert.isTrue((boolean)false);
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(n4 + n3);
        int n5 = 0;
        while (n5 < n4) {
            stringBuffer.append('\t');
            ++n5;
        }
        n5 = 0;
        while (n5 < n3) {
            stringBuffer.append(' ');
            ++n5;
        }
        return stringBuffer.toString();
    }

    private static String getStringValue(Map map, String string, String string2) {
        Object v = map.get(string);
        if (v instanceof String) {
            return (String)v;
        }
        return string2;
    }

    public static int measureIndentInSpaces(CharSequence charSequence, int n) {
        if (n < 0 || charSequence == null) {
            throw new IllegalArgumentException();
        }
        int n2 = 0;
        int n3 = charSequence.length();
        int n4 = 0;
        while (n4 < n3) {
            char c = charSequence.charAt(n4);
            if (c == '\t') {
                int n5 = n2 % n;
                n2 += n - n5;
            } else if (Indents.isIndentChar(c)) {
                ++n2;
            } else {
                return n2;
            }
            ++n4;
        }
        return n2;
    }

    public static String extractIndentString(String string, int n, int n2) {
        if (n < 0 || n2 <= 0 || string == null) {
            throw new IllegalArgumentException();
        }
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            char c = string.charAt(n7);
            if (c == '\t') {
                int n8 = n5 % n;
                n5 += n - n8;
                ++n6;
            } else {
                if (!Indents.isIndentChar(c)) break;
                ++n5;
                ++n6;
            }
            if (n5 >= n2) {
                n4 += n6;
                n6 = 0;
                n5 %= n2;
            }
            ++n7;
        }
        if (n4 == 0) {
            return "";
        }
        if (n4 == n3) {
            return string;
        }
        return string.substring(0, n4);
    }

    public static boolean isIndentChar(char c) {
        return Character.isWhitespace(c) && !Indents.isLineDelimiterChar(c);
    }

    public static boolean isLineDelimiterChar(char c) {
        return c == '\n' || c == '\r';
    }
}

