require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_ATOMIC_H_)) {
    eval 'sub _MACHINE_ATOMIC_H_ () {1;}' unless defined(&_MACHINE_ATOMIC_H_);
    if(defined(&_KERNEL)) {
	eval 'sub __SIMPLELOCK_LOCKED () {0;}' unless defined(&__SIMPLELOCK_LOCKED);
	eval 'sub __SIMPLELOCK_UNLOCKED () {1;}' unless defined(&__SIMPLELOCK_UNLOCKED);
	if(defined(&MULTIPROCESSOR)) {
	    eval 'sub ATOMIC_LOCK () { &__cpu_simple_lock( &atomic_lock);;}' unless defined(&ATOMIC_LOCK);
	    eval 'sub ATOMIC_UNLOCK () { &__cpu_simple_unlock( &atomic_lock);;}' unless defined(&ATOMIC_UNLOCK);
	} else {
	    eval 'sub ATOMIC_LOCK () {1;}' unless defined(&ATOMIC_LOCK);
	    eval 'sub ATOMIC_UNLOCK () {1;}' unless defined(&ATOMIC_UNLOCK);
	}
	eval 'sub atomic_cas_uint {
	    my($_p, $_o, $_n) = @_;
    	    eval q( &_atomic_cas_uint(($_p), ($_o), ($_n)));
	}' unless defined(&atomic_cas_uint);
	eval 'sub atomic_cas_ulong {
	    my($_p, $_o, $_n) = @_;
    	    eval q( &_atomic_cas_ulong(($_p), ($_o), ($_n)));
	}' unless defined(&atomic_cas_ulong);
	eval 'sub atomic_cas_ptr {
	    my($_p, $_o, $_n) = @_;
    	    eval q( &_atomic_cas_ptr(($_p), ($_o), ($_n)));
	}' unless defined(&atomic_cas_ptr);
	eval 'sub atomic_swap_uint {
	    my($_p, $_n) = @_;
    	    eval q( &_atomic_swap_uint(($_p), ($_n)));
	}' unless defined(&atomic_swap_uint);
	eval 'sub atomic_swap_ulong {
	    my($_p, $_n) = @_;
    	    eval q( &_atomic_swap_ulong(($_p), ($_n)));
	}' unless defined(&atomic_swap_ulong);
	eval 'sub atomic_swap_ptr {
	    my($_p, $_n) = @_;
    	    eval q( &_atomic_swap_ptr(($_p), ($_n)));
	}' unless defined(&atomic_swap_ptr);
	eval 'sub _atomic_add_int_nv {
	    my($uip,$v) = @_;
    	    eval q({  &register_t  &eiem; my $rv;  &eiem =  &atomic_enter();  $rv = *$uip + $v; *$uip =  $rv;  &atomic_leave( &eiem); ( $rv); });
	}' unless defined(&_atomic_add_int_nv);
	eval 'sub atomic_add_int_nv {
	    my($_uip, $_v) = @_;
    	    eval q( &_atomic_add_int_nv(($_uip), ($_v)));
	}' unless defined(&atomic_add_int_nv);
	eval 'sub atomic_sub_int_nv {
	    my($_uip, $_v) = @_;
    	    eval q( &_atomic_add_int_nv(($_uip), 0- ($_v)));
	}' unless defined(&atomic_sub_int_nv);
	eval 'sub _atomic_add_long_nv {
	    my($uip,$v) = @_;
    	    eval q({  &register_t  &eiem; my $rv;  &eiem =  &atomic_enter();  $rv = *$uip + $v; *$uip =  $rv;  &atomic_leave( &eiem); ( $rv); });
	}' unless defined(&_atomic_add_long_nv);
	eval 'sub atomic_add_long_nv {
	    my($_uip, $_v) = @_;
    	    eval q( &_atomic_add_long_nv(($_uip), ($_v)));
	}' unless defined(&atomic_add_long_nv);
	eval 'sub atomic_sub_long_nv {
	    my($_uip, $_v) = @_;
    	    eval q( &_atomic_add_long_nv(($_uip), 0- ($_v)));
	}' unless defined(&atomic_sub_long_nv);
	eval 'sub atomic_setbits_int {
	    my($uip,$v) = @_;
    	    eval q({  &register_t  &eiem;  &eiem =  &atomic_enter(); *$uip |= $v;  &atomic_leave( &eiem); });
	}' unless defined(&atomic_setbits_int);
	eval 'sub atomic_clearbits_int {
	    my($uip,$v) = @_;
    	    eval q({  &register_t  &eiem;  &eiem =  &atomic_enter(); *$uip &= ~$v;  &atomic_leave( &eiem); });
	}' unless defined(&atomic_clearbits_int);
	eval 'sub atomic_setbits_long {
	    my($uip,$v) = @_;
    	    eval q({  &register_t  &eiem;  &eiem =  &atomic_enter(); *$uip |= $v;  &atomic_leave( &eiem); });
	}' unless defined(&atomic_setbits_long);
	eval 'sub atomic_clearbits_long {
	    my($uip,$v) = @_;
    	    eval q({  &register_t  &eiem;  &eiem =  &atomic_enter(); *$uip &= ~$v;  &atomic_leave( &eiem); });
	}' unless defined(&atomic_clearbits_long);
	eval 'sub membar_enter () {
	    eval q( &__insn_barrier());
	}' unless defined(&membar_enter);
	eval 'sub membar_exit () {
	    eval q( &__insn_barrier());
	}' unless defined(&membar_exit);
	eval 'sub membar_producer () {
	    eval q( &__insn_barrier());
	}' unless defined(&membar_producer);
	eval 'sub membar_consumer () {
	    eval q( &__insn_barrier());
	}' unless defined(&membar_consumer);
	eval 'sub membar_sync () {
	    eval q( &__insn_barrier());
	}' unless defined(&membar_sync);
    }
}
1;
