/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/
#ifndef __rx_h_ok_
#define __rx_h_ok_

#define HEADER_SIZE						14
#define MAXIMUM_PACKET_SIZE				1500

#define	MAX_AUTHENTICATION_RETRIES			3
#define	MAX_ASSOCIATION_RETRIES				3
#define	MAX_REASSOCIATION_RETRIES				3

#define AUTHENTICATION_RESPONSE_TIME_OUT	2000
#define OUT_OF_RANGE_TIME_OUT				2000
#define	ASSOCIATION_RESPONSE_TIME_OUT		2000
#define	JOIN_TIME_OUT						2000

#define WIRELESS_HEADER_OVERHEAD		18
#define MAX_TX_PADDING_BYTES			50
#define MAX_RX_PADDING_BYTES			66
#define CRC32_BYTES						4

#define MAX_WIRELESS_SIZE    WIRELESS_HEADER_OVERHEAD + HEADER_SIZE + MAXIMUM_PACKET_SIZE + CRC32_BYTES

//
// Offsets of some fields in frames
//
#define MGMT_FRAME_SA_OFFSET						10
#define MGMT_FRAME_DA_OFFSET						 4
#define DATA_FRAME_ADHOC_SA_OFFSET					10
#define DATA_FRAME_INFR_SA_OFFSET					16

#define SSID_ELLEMENT_OFFSET						14			//12+2
#define SSID_ELLEMENT_LENGTH_OFFSET					13			//12+1
#define SUP_RATES_ELLEMENT_LENGTH_REL_OFFSET		15			//12+2+1
#define DS_PARAM_SET_ELLEMENT_REL_OFFSET			18			//12+2+2+2
#define BSSID_HEADER_OFFSET							16
#define MGMT_FRAME_BODY_OFFSET						24

#define WIRELESS_HEADER_ADDRESS3_OFFSET			16
#define CAPABILITY_INFO_IN_BEACON_OFFSET		10
#define STATUS_IN_AUTHENTICATION_OFFSET			4
#define TRANS_SEQ_NO_IN_AUTHENTICATION_OFFSET		2
#define CHALL_TEXT_EL_ID_IN_AUTHENTICATION_OFFSET	6
#define CHALL_TEXT_LENGTH_IN_AUTHENTICATION_OFFSET	7
#define CHALL_TEXT_IN_AUTHENTICATION_OFFSET		8

#define STATUS_IN_ASSOCIATION_RESP_OFFSET			2
#define ASS_ID_IN_ASSOCIATION_RESP_OFFSET			4
#define SUP_RATES_LENGTH_IN_ASSOCIATION_RESP_OFFSET	7
#define SUP_RATES_IN_ASSOCIATION_RESP_OFFSET		8


#endif //__rx_h_ok__
