/*
 * linux/arch/arm/mach-sa1100/jornada720.c
 */

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/tty.h>
#include <linux/delay.h>

#include <asm/hardware.h>
#include <asm/arch/irqs.h>
#include <asm/setup.h>

#include <asm/mach/arch.h>
#include <asm/mach/map.h>
#include <asm/mach/serial_sa1100.h>
#include <linux/sched.h>
#include <linux/serial_core.h>

#include "generic.h"
#include "sa1111.h"
#include <asm/hardware/sa1111.h>

#include <linux/wait.h>          /* for wait_queue_head_t, used in h3600_ts.h */
#include <linux/types.h>         /* for u_char, used in h3600_ts.h */
#include <linux/h3600_ts.h>      /* for TS_RET */
#include <linux/pm.h>
#include <asm/arch/pm.h>

#define JORTUCR_VAL	0x20000400
#define JORSKCR_INIT	0x00002081	/* Turn off VCO to enable PLL, set Ready En and enable nOE assertion from DC */
#define JORSKCR_RCLK	0x00002083	/* Add turning on RCLK to above */
#define JORSKCR_VAL	0x0000001B	/* sets the 1101 control register to on */

#define MCU_GetBatteryData     0xc0
#define MCU_GetScanKeyCode     0x90
#define MCU_GetTouchSamples    0xa0
#define MCU_GetContrast        0xD0
#define MCU_SetContrast        0xD1
#define MCU_GetBrightness      0xD2
#define MCU_SetBrightness      0xD3
#define MCU_ContrastOff        0xD8
#define MCU_BrightnessOff      0xD9
#define MCU_PWMOff             0xDF

#define MCU_TxDummy         0x11
#define MCU_ErrorCode       0x00
#define SA1100_PPDR_LFCLK 	0x400

#define mcu_read() mcu_byte(MCU_TxDummy)

static char mcu_invert[256];
static int suspended = 0;
static struct pm_dev *jornada720_pm_dev;
void jornada_init_ser(void)
{
int i;

	GPSR = 0x02000000;
	Ser4SSCR0 = 0x0307;
	Ser4MCCR0 = 0;
	Ser4SSSR = 0; 
	Ser4SSCR1 = 0x18;
	Ser4SSCR0 = 0x0387;
	while (Ser4SSSR & SSSR_RNE)
	   i = Ser4SSDR;  
 }
								        
static int mcu_byte(int arg_data)
{
        int i;

	while ((Ser4SSSR & SSSR_TNF) == 0);
	i = 0;
	while ((GPLR & 0x400) && i++ < 400000)
		; /* wait for MCU */
	if (i >= 400000) {
		printk("mcu_byte: timed out\n");
                return -1;
        }
	Ser4SSDR = mcu_invert[arg_data] << 8;
	udelay(100);
	while ((Ser4SSSR & SSSR_RNE) == 0);
	i = Ser4SSDR;
	if (i > 0xff)
		printk("mcu_byte: read %x\n", i);
	return mcu_invert[ i & 0xff ] & 0xff;
}

static int mcu_start(int arg_data)
{
        int i;

	jornada720_mcu_init();
	GPCR = 0x02000000; /* clear -> enable */
	udelay(100);
	i = mcu_byte(arg_data);
	if (i != MCU_TxDummy)
	{
		printk("mcu_start: sent %x got %x\n", arg_data, i);
	        for (i = 0; i < 256; i++)
	  		if (mcu_read() == -1)
	   			break;
	   	jornada_init_ser();   
		 return -1;
  	}
  	return 0;
}

static void mcu_end(void)
{
#if 1
	udelay(100);
#endif
	GPSR = 0x02000000; /* set */
}

void jornada720_mcu_init(void)
{
        int i;
        static int initialized = 0;

	if (initialized)
		return;
        printk ("[%s:%d] %s ENTRY\n", __FILE__, __LINE__, __FUNCTION__);
	initialized = 1;
	PPSR &= ~(SA1100_PPDR_LFCLK | 0x80 | 0x10);
	udelay(500);
        printk ("[%s:%d] %s PPSR reset\n", __FILE__, __LINE__, __FUNCTION__);
	PPDR |= SA1100_PPDR_LFCLK | 0x80 | 0x10;
	udelay(500);
        printk ("[%s:%d] %s after reset\n", __FILE__, __LINE__, __FUNCTION__);
	/* Take the MCU out of reset mode */
	PPSR |= SA1100_PPDR_LFCLK;
	udelay(500);
	printk ("now wait after reset done\n");
	for (i = 0; i <= 255; i++)
		mcu_invert[i] = ( ((0x80 & i) >> 7) | ((0x40 & i) >> 5)
                                  | ((0x20 & i) >> 3) | ((0x10 & i) >> 1) | ((0x08 & i) << 1)
                                  | ((0x04 & i) << 3) | ((0x02 & i) << 5) | ((0x01 & i) << 7) );

	GPSR = 0x02000000; /* set */
	GPDR |= 0x02000000; /* GPIO(25) low -> enable MCU */
	Ser4SSCR0 = 0x0307;
	Ser4MCCR0 = 0;
	Ser4SSSR = 0;	/* remove any rcv overrun errors */
	Ser4SSCR1 = 0x18;
	Ser4SSCR0 = 0x0387;

	while (Ser4SSSR & SSSR_RNE)
		i = Ser4SSDR;		/* drain any data already there */
}

static int jornada720_pm_callback(struct pm_dev *pm_dev,
        pm_request_t req, void *data)
 {
 	switch (req) {
       	case PM_SUSPEND: /* Enter D1-D3 */
             suspended = 1;
  	      break;
       	case PM_RESUME:  /* Enter D0 */
      	        if ( suspended ) {
                      suspended = 0;
       	              GPSR = GPIO_GPIO8; /* turn on RS232 transceiver */
                      jornada_init_ser();
                   }
         	   break;
       	}
      	return 0;
}
static void suspend_button_task_handler(void *data)
{
#if 0
       PGSR = GPIO_GPIO20 /* don't reset SA1111 */
       | GPIO_GPIO8 /* leave RS232 transciever on */
       | GPIO_GPIO25; /* don't reset MCU */
       PSDR = PPC_TXD4 | PPC_L_FCLK | PPC_LDD7 | PPC_LDD4; //0x80 | 0x10;
 #else
 PSDR = PPDR | PPC_TXD4; /* PPC sleep mode direction */
 PGSR = GPLR; /* preserve GPIO levels */
 #endif
             PGSR &= ~GPIO_GPIO8;	/* RS232 transceiver off */
             PCFR = PCFR_OPDE;
             PWER = GPIO_JORNADA720_KEYBOARD | GPIO_JORNADA720_MOUSE | PWER_RTC;
         pm_suggest_suspend();
 }                                                             
 static struct tq_struct  suspend_button_task =
          { routine: suspend_button_task_handler };




void jornada_contrast(int arg_contrast)
{
	mcu_start(MCU_SetContrast);
	mcu_byte(arg_contrast);
	mcu_end();
}

int jornada_brightness(int arg_brightness)
{
	int i = 0;

        if (arg_brightness) {
          mcu_start(MCU_SetBrightness);
          i = mcu_byte(arg_brightness);
        } else {
          mcu_start(MCU_PWMOff);
        }
        
	mcu_end();
	return i;
}

void jornada720_battery(void)
{
	mcu_start(MCU_GetBatteryData);
	printk("get2 bat %x\n", mcu_read());
	printk("get3 bat %x\n", mcu_read());
	printk("get4 bat %x\n", mcu_read());
	mcu_end();
}

int jornada720_getkey(unsigned char *data, int size)
{
	int this_count, i, j, this_suspend = 0;

	mcu_start(MCU_GetScanKeyCode);
	this_count = mcu_read();	/* Flush any pending input. */
	i = this_count;
	while (i-- > 0) {
		j = mcu_read();
		if ((j & 0xffffff7f) == 0x7f) {
		 	printk("power [%x]\n", j);
	         	if (j == 0xff) this_suspend = 1;
	         }
		
		if (size-- > 0)
			*data++ = j;
	}
	mcu_end();
	if (this_suspend) {
	       suspend_button_task.data = (void *) 0;
	       schedule_task(&suspend_button_task);  
	 }
	return this_count;
}

static int sort_vec(int *arg_data)
{
	int i, temp, total;

	for (i = 0; i < 2; i++)
		if (arg_data[i] > arg_data[i+1]) {
			temp = arg_data[i];
			arg_data[i] = arg_data[i+1];
			arg_data[i+1] = temp;
		}
	i = 0;
	if (arg_data[i] > arg_data[i+1]) {
		temp = arg_data[i];
		arg_data[i] = arg_data[i+1];
		arg_data[i+1] = temp;
	}
	total = 2;
	if (arg_data[1] < (arg_data[0] * 11) / 10) {
		temp = arg_data[0] + arg_data[1];
		if (arg_data[2] < (arg_data[0] * 11) / 10) {
			temp += arg_data[2];
			total++;
		}
	}
	else if (arg_data[2] < (arg_data[1] * 11) / 10)
		temp = arg_data[1] + arg_data[2];
	else
		return -1;
	return temp/total;
}
int jornada720_gettouch(int *arg_x, int *arg_y)
{
	int X[3], Y[3], high_x, high_y;
	int this_return;

	mcu_start(MCU_GetTouchSamples);
	X[0] = mcu_read();
	X[1] = mcu_read();
	X[2] = mcu_read();
	Y[0] = mcu_read();	
	Y[1] = mcu_read();
	Y[2] = mcu_read();
	high_x = mcu_read(); /* msbs of samples */
	high_y = mcu_read();	
	mcu_end();

	X[0] |= (high_x & 3) << 8;
	X[1] |= (high_x & 0xc) << 6;
	X[2] |= (high_x & 0x30) << 4;

	Y[0] |= (high_y & 3) << 8;
	Y[1] |= (high_y & 0xc) << 6;
	Y[2] |= (high_y & 0x30) << 4;

        /* simple averaging filter */
	*arg_x = (X[0] + X[1] + X[2])/3;
	*arg_y = (Y[0] + Y[1] + Y[2])/3;

	this_return = ( (GPLR & GPIO_JORNADA720_MOUSE) == 0);
	return this_return;
}

static void jornada720_cleanup_module(void)
{
 	flush_scheduled_tasks(); /* make sure all tasks have run */
 	pm_unregister(jornada720_pm_dev);
 }
 	 	
 	 	

static int __init jornada720_init(void)
{
	int ret;

	GPDR |= GPIO_GPIO20;
	TUCR = JORTUCR_VAL;	/* set the oscillator out to the SA-1101 */

	GPSR = GPIO_GPIO20;
	udelay(1);
	GPCR = GPIO_GPIO20;
	udelay(1);
	GPSR = GPIO_GPIO20;
	udelay(20);
	SBI_SKCR = SKCR_OE_EN|SKCR_PLL_BYPASS|SKCR_RDYEN;	/* Turn on the PLL, enable Ready and enable nOE assertion from DC */
	mdelay(100);

	/* also turn on the RCLOCK */
	SBI_SKCR = SKCR_OE_EN|SKCR_PLL_BYPASS|SKCR_RDYEN|SKCR_RCLKEN;
	SBI_SMCR = 0x35;	/* initialize the SMC (debug SA-1111 reset */
	PCCR = 0;	/* initialize the S2MC (debug SA-1111 reset) */

	/* LDD4 is speaker, LDD3 is microphone */
	PPSR &= ~(PPC_LDD3 | PPC_LDD4);
	PPDR |= PPC_LDD3 | PPC_LDD4;

        /*
         * Probe for a SA1111.
         */
        ret = sa1111_probe(JORNADA720_SA1111_BASE);
        if (ret < 0)
                return ret;

        /*
         * We found it.  Wake the chip up.
         */
        sa1111_wake();

	/* configure SDRAM ?? */
	sa1111_configure_smc(1,
		FExtr(MDCNFG, MDCNFG_SA1110_DRAC0),
		FExtr(MDCNFG, MDCNFG_SA1110_TDL0));
	/*
	 * We only need to turn on DCLK whenever we want to use the
	 * DMA.  It can otherwise be held firmly in the off position.
	 */
	SKPCR |= SKPCR_DCLKEN;

	sa1110_mb_enable();
	/* initialize extra IRQs */
        set_GPIO_IRQ_edge(GPIO_GPIO1, GPIO_RISING_EDGE);
	sa1111_init_irq(JORNADA720_SA1111_GPIO);	/* chained on GPIO 1 */
	jornada720_mcu_init();
	jornada720_pm_dev = pm_register(PM_UNKNOWN_DEV, PM_SYS_UNKNOWN, jornada720_pm_callback);
	PPSR &= ~(PPC_L_FCLK | PPC_LDD7 | PPC_LDD4);
	PPSR |= PPC_L_FCLK;
	udelay(500);
	jornada_init_ser();
	return 0;
}

__initcall(jornada720_init);

static void __init
fixup_jornada720(struct machine_desc *desc, struct param_struct *params,
		 char **cmdline, struct meminfo *mi)
{
#if 0 /* jca */
	SET_BANK( 0, 0xc0000000, 32*1024*1024 );
	mi->nr_banks = 1;
#endif
}

static void uart_pm(struct uart_port *port, u_int state, u_int oldstate)
{
#if 0
     if (port->mapbase == _Ser2UTCR0) { /* TODO: REMOVE THIS */
      assign_h3600_egpio( IPAQ_EGPIO_IR_ON, !state );
     } else if (port->mapbase == _Ser3UTCR0) {
     assign_h3600_egpio( IPAQ_EGPIO_RS232_ON, !state );
     }
  #endif
}          

static int uart_set_wake(struct uart_port *port, u_int enable)
{
 int err = -EINVAL;
 	
 if (port->mapbase == _Ser3UTCR0) {
 	#if 0
 	if (enable)
 	 PWER |= PWER_GPIO23 | PWER_GPIO25 ; /* DCD and CTS */
 	else
 	 PWER &= ~(PWER_GPIO23 | PWER_GPIO25); /* DCD and CTS */
 	#endif
 	err = 0;
 	}
	return err;
}
 		     		     		             		     		    	      		      	      	 

static int uart_open(struct uart_port *port, struct uart_info *info)
{
 	int ret = 0;
 	
 	#if 0
 	if (port->mapbase == _Ser2UTCR0) {  /* TODO: REMOVE THIS */
 	  Ser2UTCR4 = UTCR4_HSE;
 	  Ser2HSCR0 = 0;
 	  Ser2HSSR0 = HSSR0_EIF | HSSR0_TUR |
 	  		HSSR0_RAB | HSSR0_FRE;
 	} else if (port->mapbase == _Ser3UTCR0) {
 	set_GPIO_IRQ_edge(GPIO_H3600_COM_DCD|GPIO_H3600_COM_CTS,
 			 GPIO_BOTH_EDGES);
 		        ret = request_irq(IRQ_GPIO_H3600_COM_DCD, dcd_intr,
 		        0, "RS232 DCD", info);
		if (ret)
				        return ret;
				        
			ret = request_irq(IRQ_GPIO_H3600_COM_CTS, cts_intr,
		    	0, "RS232 CTS", info);
		 if (ret)
      free_irq(IRQ_GPIO_H3600_COM_DCD, info);
	  }
	   #endif   
	   return ret;
 }
				        				                  				        	         				        	        	        	             
static void uart_close(struct uart_port *port, struct uart_info *info)
{
 	if (port->mapbase == _Ser3UTCR0) {
 	#if 0
 	 free_irq(IRQ_GPIO_H3600_COM_DCD, info);
 	 free_irq(IRQ_GPIO_H3600_COM_CTS, info);
 	 #endif
	}
}
 	     		     		        

static void uart_set_mctrl(struct uart_port *port, u_int mctrl)
{
#if 0
 if (port->mapbase == _Ser3UTCR0) {
    	if (mctrl & TIOCM_RTS)
      	GPCR = GPIO_H3600_COM_RTS;
      	else
      	GPSR = GPIO_H3600_COM_RTS;
         }
#endif
 }


static u_int uart_get_mctrl(struct uart_port *port)
{
 u_int ret = TIOCM_CD | TIOCM_CTS | TIOCM_DSR;
 	
 #if 0
if (port->mapbase == _Ser3UTCR0) {
 	       int gplr = GPLR;
 	   /* DCD and CTS bits are inverted in GPLR by RS232 transceiver */
 	     if (gplr & GPIO_H3600_COM_DCD)
 	            ret &= ~TIOCM_CD;
 	     if (gplr & GPIO_H3600_COM_CTS)
                ret &= ~TIOCM_CTS;                                                             
                }
#endif   
 	                                                                                                                                
 	   return ret;
}
 	                                                                                                                                	

static void dcd_intr(int irq, void *dev_id, struct pt_regs *regs)
{
#if 0
  struct uart_info *info = dev_id;
     /* Note: should only call this if something has changed */
     /* DCD and CTS bits are inverted in GPLR by RS232 transceiver */
     uart_handle_dcd_change(info, !(GPLR & GPIO_H3600_COM_DCD));
#endif
}
                                 
static void cts_intr(int irq, void *dev_id, struct pt_regs *regs)
  {
   #if 0
     struct uart_info *info = dev_id;
           /* Note: should only call this if something has changed */
           /* DCD and CTS bits are inverted in GPLR by RS232 transceiver */
           uart_handle_cts_change(info, !(GPLR & GPIO_H3600_COM_CTS));
          #endif
}
                                                                 
static struct sa1100_port_fns port_fns __initdata = {
  set_mctrl:      uart_set_mctrl,
  get_mctrl:      uart_get_mctrl,
  pm:		uart_pm,
  set_wake:       uart_set_wake,
  open:           uart_open,
  close:          uart_close,
 };


static struct map_desc jornada720_io_desc[] __initdata = {
        /* virtual     physical    length      domain     r  w  c  b */
        { 0xe8000000, 0x00000000, 0x02000000, DOMAIN_IO, 0, 1, 0, 0 }, /* Flash bank 0 */
        { 0xf0000000, 0x48000000, 0x00100000, DOMAIN_IO, 0, 1, 0, 0 }, /* Epson registers */
        { 0xf1000000, 0x48200000, 0x00100000, DOMAIN_IO, 0, 1, 0, 0 }, /* Epson frame buffer */
        { 0xf4000000, 0x40000000, 0x00100000, DOMAIN_IO, 0, 1, 0, 0 }, /* SA-1111 */
        LAST_DESC
};

static void __init jornada720_map_io(void)
{
	sa1100_map_io();
	iotable_init(jornada720_io_desc);
	sa1100_register_uart_fns(&port_fns);
	sa1100_register_uart(0, 3);
	sa1100_register_uart(1, 1);
	/* Configure suspend conditions */
	 	PGSR = GPIO_GPIO20 /* don't reset SA1111 */
	 	  	| GPIO_GPIO8 /* leave RS232 transceiver on */
	 	  	| GPIO_GPIO25; /* don't reset MCU */
	        PWER = GPIO_JORNADA720_KEYBOARD | PWER_RTC;
	        PCFR = PCFR_OPDE;
		PSDR = PPC_L_FCLK | PPC_LDD7 | PPC_LDD4;
}

MACHINE_START(JORNADA720, "HP Jornada 720")
BOOT_MEM(0xc0000000, 0x80000000, 0xf8000000)
BOOT_PARAMS(0xc0000100)
FIXUP(fixup_jornada720)
MAPIO(jornada720_map_io)
INITIRQ(sa1100_init_irq)
MACHINE_END
