.\" $XFree86: xc/programs/Xserver/hw/xfree86/drivers/i810/i810.man,v 1.5 2003/10/18 02:27:07 dawes Exp $ 
.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH I810 __drivermansuffix__ __vendorversion__
.SH NAME
i810 \- Intel 8xx integrated graphics chipsets
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qi810\*q"
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B i810
is an XFree86 driver for Intel integrated graphics chipsets.
The driver supports depths 8, 15, 16 and 24.  All visual types are
supported in depth 8.  For the i810/i815 other depths support the
TrueColor and DirectColor visuals.  For the 830M and later, only the
TrueColor visual is supported for depths greater than 8.  The driver
supports hardware accelerated 3D via the Direct Rendering Infrastructure
(DRI), but only in depth 16 for the i810/i815 and depths 16 and 24 for
the 830M and later.
.SH SUPPORTED HARDWARE
.B i810
supports the i810, i810-DC100, i810e, i815, 830M, 845G, 852GM, 855GM,
and 865G chipsets.

.SH CONFIGURATION DETAILS
Please refer to XF86Config(__filemansuffix__) for general configuration
details.  This section only covers configuration details specific to this
driver.
.PP
The Intel 8xx family of integrated graphics chipsets has a unified memory
architecture and uses system memory for video ram.  For the i810 and
i815 familiy of chipset, operating system support for allocating system
memory for video use is required in order to use this driver.  For the
830M and later, this is required in order for the driver to use more
video ram than has been pre-allocated at boot time by the BIOS.  This
is usually achieved with an "agpgart" or "agp" kernel driver.  Linux,
and recent versions of FreeBSD, OpenBSD and NetBSD have such kernel
drivers available.
.PP
By default 8 Megabytes
of system memory are used for graphics.  For the 830M and later, the
default is 8 Megabytes when DRI is not enabled and 32 Megabytes with
DRI is enabled.  This amount may be changed with the
.B VideoRam
entry in the config file
.B "Device"
section.  It may be set to any reasonable value up to 64MB for older
chipsets or 128MB for newer chipets.  It is advisable to check the XFree86
log file to check if any features have been disabled because of insufficient
video memory.  In particular, DRI support or tiling mode may be disabled
with insufficient video memory.  Either of these being disabled will
reduce performance for 3D applications.  Note however, that increasing
this value too much will reduce the amount of system memory available
for other applications.
.PP
The driver makes use of the video BIOS to program video modes for the 830M
and later.  This limits the video modes that can be used to those provided
by the video BIOS, and to those that will fit into the amount of video memory
that the video BIOS is aware of.
.PP
The following driver
.B Options
are supported
.TP
.BI "Option \*qNoAccel\*q \*q" boolean \*q
Disable or enable acceleration.  Default: acceleration is enabled.
.TP
.BI "Option \*qSWCursor\*q \*q" boolean \*q
Disable or enable software cursor.  Default: software cursor is disable
and a hardware cursor is used for configurations where the hardware cursor
is available.
.TP
.BI "Option \*qColorKey\*q \*q" integer \*q
This sets the default pixel value for the YUV video overlay key.
Default: undefined.
.TP
.BI "Option \*qCacheLines\*q \*q" integer \*q
This allows the user to change the amount of graphics memory used for
2D acceleration and video.  Decreasing this amount leaves more for 3D
textures.  Increasing it can improve 2D performance at the expense of
3D performance.
Default: depends on the resolution, depth, and available video memory.  The
driver attempts to allocate at least enough to hold two DVD-sized YUV buffers
by default.  The default used for a specific configuration can be found
by examining the XFree86 log file.
.TP
.BI "Option \*qDRI\*q \*q" boolean \*q
Disable or enable DRI support.
Default: DRI is enabled for configurations where it is supported.

.PP
The following driver
.B Options
are supported for the i810 and i815 chipsets:
.TP
.BI "Option \*qDDC\*q \*q" boolean \*q
Disable or enable DDC support.
Default: enabled.
.TP
.BI "Option \*qDac6Bit\*q \*q" boolean \*q
Enable or disable 6-bits per RGB for 8-bit modes.
Default: 8-bits per RGB for 8-bit modes.
.TP
.BI "Option \*qXvMCSurfaces\*q \*q" integer \*q
This option enables XvMC.  The integer parameter specifies the number of
surfaces to use.  Valid values are 6 and 7.
Default: XvMC is disabled.

.PP
The following driver
.B Options
are supported for the 830M and later chipsets:
.TP
.BI "Option \*qVideoKey\*q \*q" integer \*q
This is the same as the
.B \*qColorKey\*q
option described above.  It is provided for compatibility with most
other drivers.
.TP
.BI "Option \*qXVideo\*q \*q" boolean \*q
Disable or enable XVideo support.
Default: XVideo is enabled for configurations where it is supported.


.SH "SEE ALSO"
XFree86(1), XF86Config(__filemansuffix__), xf86config(1), Xserver(1), X(__miscmansuffix__)
.SH AUTHORS
Authors include: Keith Whitwell, and also Jonathan Bian, Matthew J Sottek, 
Jeff Hartmann, Mark Vojkovich, Alan Hourihane, H. J. Lu.  830M and 845G
support reworked for XFree86 4.3 by David Dawes and Keith Whitwell.
852GM, 855GM, and 865G support added by David Dawes and Keith Whitwell.
