/***********************************************************************/
/*	strright.c                                                    */
/***********************************************************************/

/* function to extract the rightmost characters of a string */
/* starting at a given character positon                    */
strright(ins,outs,pos,maxsize)
char *ins; /* source string */
char *outs; /* output (target) string */
int pos; /* starting character position */
int maxsize; /* size of output (target) string */
{
int i; /* return value ( actual characters extracted ) */
/* check for negative starting postion */
if(pos < 0) return(-1);
/* check for non positive maximun size */
if(maxsize < 1) return(-2);
/* check for starting position passed null terminator */
for(i = 0; i < pos; ++i)
  {
  if(ins[i] == '\0') return(-3);
  }
for(i = pos; i < (maxsize + pos - 1); ++i)
  {
  outs[i - pos] = ins[i];
  if(ins[i] == '\0') return(i - pos);
  }
outs[i - pos] = '\0';
return(i - pos);
}
