/***********************************************************************/
/*	wrtch.c                                                       */
/***********************************************************************/

wrtch(count,charac) /* write character using existing attributes */
int count; /* the count of how many times to print the character */
char charac; /* the character to print */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */

  if ( count <= 0 || count > 16384 )
     return(-1);
  regs.es=regs.ds=0;   /* default value - no changes to register */
  regs.ah=15;  /* get current mode. sets bh = current display page  */
  int_no=0x10; /* video I/O BIOS call */
  ret_code = gdosint(int_no,&regs,&regs);
  regs.ch=count / 256;
  regs.cl=count - (regs.ch*256);
  regs.al=charac;
  regs.es=regs.ds=0;   /* default value - no changes to register */
  regs.ah=10;
  int_no=0x10; /* video I/O BIOS call */
  ret_code = gdosint(int_no,&regs,&regs);
  return(0);
}
