/***********************************************************************/
/*	setmblk.c                                                     */
/***********************************************************************/

/* set blocksize in segment */
setmblk(segment,blk_size,max_blks)
unsigned segment; /* the segment of the block being set */
unsigned blk_size; /* block size requested in paragraphs */
unsigned *max_blks; /* actual number of paragraphs set returned */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */

  regs.es=segment; /* load es register with segment number */
  regs.bh=blk_size/256; /* load bx with block size */
  regs.bl=blk_size - (regs.bh*256);
  regs.ah=0x4A;  /* DOS function call */
  int_no=0x21;  /* interrupt number for DOS function call */
  ret_code = gdosint(int_no,&regs,&regs);
  *max_blks= (regs.bh*256) + regs.bl;  /* max is returned in bx register */
  return(ret_code);
}
