/***********************************************************************/
/*	execute2.c                                                    */
/***********************************************************************/

/* Lattice Ver 2.0 and CI-C86 version of execute */ 
execute2(program,cmd_line)
char *program; /* name of program to execute */
char *cmd_line; /* parameters to pass to program on command line */
{
#ifdef _C86_BIG
#define LPTR 1
#endif

#ifdef LATTICE
  extern long int _PSP; /* program segment prefix segment and offset */
#else
  extern long int _PSPSEG; /* program segment prefix segment and offset */
#endif

  struct {          /* parameter block used in exec call */
    unsigned environment;  /* segment address of environment */

#ifdef LPTR   /* Lattice 2.0 and CI-C86 large data models */
    long int cmd;          /* segment and offset from long pointer */
#else
    unsigned cmd_off;      /* offset address of command line */
    unsigned cmd_seg;      /* segment address of command line */
#endif

    unsigned fcb1_off;     /* offset address of first file control block */
    unsigned fcb1_seg;     /* segment address of first file control block */
    unsigned fcb2_off;     /* offset address of second file control block */
    unsigned fcb2_seg;     /* segment address of second file control block */
  } block;


  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */

  unsigned pspseg;  /* segment address of program segment prefix  */
  unsigned size;    /* temporary variable used in shrinkm */
  int error;        /* temporary variable used in shrinkm call   */
  char line[129];   /* altered command line to be passed (in psp format) */
  int length;       /* temporary variable used in strlen     */
  unsigned *tempptr; /* temporary pointer used to get environment address */


#ifdef LATTICE
  error = shrinkm2(&size);
  if ( error != 0 )  /* return if there was a problem in shrinking */ 
     return(-error); /* make return code negative to distinguish */
                         /* this return from the exec function return */
#endif

  int_no=0x00;  /* special call to gdosint to return current register values*/
  ret_code = gdosint(int_no,&regs,&regs);

#ifdef LATTICE
  pspseg = hiword(_PSP); /* prog segment prefix segment */
#else
  pspseg = hiword(_PSPSEG); /* prog segment prefix segment */
#endif

/* get address of environment (2 bytes) with segmov below */
/* 0x2C is offset in pspseg of environment address */

#ifdef LPTR

  segmov(2,0x2C,pspseg,&block.environment);

#else

  segmov(2,0x2C,pspseg,&block.environment,regs.ds);

#endif


/* *********** code deleted for ifdef fix above *******************
  tempptr = pspseg + 0x2C;  /* environment address at 2C in PSP */
  block.environment = *tempptr;  /* pass environment of caller */
**************             *************** ******************* **** */



  block.fcb1_seg = pspseg;
  block.fcb1_off = 0x5C;     /* use default fcbs at offsets 5C & 6C in psp */
  block.fcb2_seg = pspseg;
  block.fcb2_off = 0x6C;

    
/* The first byte of the command line passed must contain the length of    */
/* the parameter string passed. This is the format that DOS uses when      */
/* placing the line at offset 80H in the Program Segment Prefix.           */

  length = strlen(cmd_line);  /* get length of command line passed */
  line[0] = (char) length;    /* put length in first byte of line  */
  line[1] = '\0';	      /* make line a string                */
  strcat(line,cmd_line); /* concatenate the passed line to the length */


#ifdef LPTR    /* large data models with long pointers */


  block.cmd = &line[0];

  regs.es = hiword(&block); /* segment ad of block */
  regs.bh = (unsigned) (&block) >> 8; 
  regs.bl = (unsigned) (&block) - (regs.bh << 8);
  regs.ds = hiword(program); /* segment ad of program */
  regs.dh = (unsigned) (program) >> 8;  /* dx reg gets offset of program */
  regs.dl = (unsigned) (program) - (regs.dh << 8);
#else

  block.cmd_seg = regs.ds;    /* use default ds from gdosint call above */
  block.cmd_off = (unsigned) line;  /* offset of line in data segment */
  regs.bh = (unsigned) (&block) >> 8;  /* bx register gets address of block */
  regs.bl = (unsigned) (&block) - (regs.bh << 8);
  regs.dh = (unsigned) (program) >> 8;  /* dx reg gets address of program */
  regs.dl = (unsigned) (program) - (regs.dh << 8);

#endif

  regs.al = 0;     /* EXEC call to load & run program with psp */
  regs.ah = 0x4B;  /* DOS function number for EXEC call */

  int_no=0x21; /* interrupt number for DOS function call */
  ret_code = gdosint(int_no,&regs,&regs);
  return(ret_code);

}
