/***********************************************************************/
/*	alocatem.c                                                    */
/***********************************************************************/

/*  allocate blocks of memory */
alocatem(paragraphs,blk_ptr)
unsigned paragraphs; /* number of paragraphs requested */
unsigned *blk_ptr; /* pointer to allocated memory is returned */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */

  regs.ds=regs.es=0; /* default es reg. */
  regs.bh=paragraphs/256;  /* number requested loaded into bx register */
  regs.bl=paragraphs - (regs.bh*256);
  regs.ah=0x48;  /* DOS function call */
  int_no=0x21;  /* interrupt number for DOS function call */
  ret_code = gdosint(int_no,&regs,&regs);
  if (ret_code != 0){           /* if call fails, the largest memory block */
                                /* size is returned in bx.                 */
     *blk_ptr = (regs.bh*256) + regs.bl;
     return(ret_code);
  }else{
     *blk_ptr = (regs.ah*256) + regs.al;  /* pointer returned in ax */
      return(ret_code);
  }
}

