/***********************************************************************/
/*	ecokeycl.c                                                    */
/***********************************************************************/

ecokeycl(charac) /* clear keyboard buffer then console input with echo */
int *charac; /* scan code returned to caller */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */

  regs.es=regs.ds=0;   /* default value - no changes to register */
  regs.ah=0xC;      /* clear keyboard buffer and execute function in al */
  regs.al=0x1;      /* console input with echo to stdio */
  int_no=0x21;
  ret_code = gdosint(int_no,&regs,&regs);
  if (regs.al == 0 )  /* if extended code, get code but do not echo to stdio */
     {
       regs.es=regs.ds=0;   /* default value - no changes to register */
       regs.ah=8;    /* console input without echo */
       ret_code = gdosint(int_no,&regs,&regs);
       *charac=regs.al;
       return(1);
     }
  else
     {
       *charac=regs.al;
       return(0);
  }

}
