/***********************************************************************/
/*	setstamp.c                                                    */
/***********************************************************************/

/*  set a files time and date stamps  */
setstamp(handle,filedate,filetime)
unsigned handle;  /* DOS handle of file to be set */
unsigned filedate; /* new date to be set */
unsigned filetime; /* new time to be set */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */

  regs.ds=regs.es=0; /* default es reg. */
  regs.al=1;  /* set time part of DOS function 0x57 */
  regs.ah=0x57; /* DOS function number */
  regs.bh=handle/256; /* put handle in bx register */
  regs.bl=handle - (regs.bh*256);
  regs.dh= filedate/256; /* date goes in dx register for DOS call */
  regs.dl= filedate - (regs.dh*256);
  regs.ch= filetime/256; /* time in cx register */
  regs.cl= filetime - (regs.ch*256);
  int_no=0x21;  /* interrupt number for DOS function call */
  ret_code = gdosint(int_no,&regs,&regs);
  return(ret_code);
}
