/***********************************************************************/
/*	readfil.c                                                     */
/***********************************************************************/

/* read part of a file into a buffer */
readfil(handle,bytes,buffer,actual_count)
unsigned handle; /* 16 bit handle returned from open */
unsigned bytes;  /* number of bytes to read */
char *buffer;  /* ptr to buffer area to transfer data to */
unsigned *actual_count; /* ptr to return actual number of bytes read */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */


#ifdef LPTR
			/* if big data models => get segment part of */
			/*     address pointer          */
  regs.ds= hiword(buffer);

#else

  regs.ds=0;		/* else => use default DS */

#endif

  regs.es=0; /* default es reg. */
  regs.bh=handle >> 8 ; /* handle loaded into bx register */
  regs.bl=handle - (regs.bh << 8);
  regs.ch=bytes >> 8; /* read count loaded into cx register */
  regs.cl=bytes - (regs.ch << 8);
  regs.dh= (unsigned) (buffer) >> 8 ; /* buffer ptr loaded into dx */
  regs.dl= (unsigned) (buffer) - (regs.dh << 8);
  regs.ah=0x3F;  /* DOS function number */
  int_no=0x21;  /* interrupt number for DOS function call */
  ret_code = gdosint(int_no,&regs,&regs);
  *actual_count = (regs.ah << 8) + regs.al ; /* count returned in ax */
  return(ret_code);
}
