/***********************************************************************/
/*	openfil.c                                                     */
/***********************************************************************/
#ifdef _C86_BIG
#define LPTR 1
#endif

/* open a file */
openfil(pname,access,handle)
char *pname; /* pointer to full path name (ASCIIZ) string of filename */
int access; /* type of access requested - 0= read, 1= write, 2= both  */
unsigned *handle; /* 16 bit handle returned and used by other functions */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */
 
  if ( access < 0 || access > 3 )  /* invalid access passed */
     return(-1);

#ifdef LPTR
			/* if big data models => get segment part of */
			/*     ASCII string address pointer          */
  regs.ds= hiword(pname);

#else

  regs.ds=0;		/* else => use default DS */

#endif

  regs.es=0;   /* default value for registers */
			/* put offset address into dx register */
  regs.dh= (unsigned) (pname) >> 8; 
  regs.dl= (unsigned) (pname) - (regs.dh << 8); 

  regs.al= access;
  regs.ah=0x3D; /* DOS function number */
  int_no=0x21; /* interrupt number for DOS function call */
  ret_code = gdosint(int_no,&regs,&regs);
  *handle = (regs.ah >> 8) + regs.al;  /* handle returned in ax register */
  return(ret_code); /* if other than 0; handle is invalid */
}
