/***********************************************************************/
/*	getstamp.c                                                    */
/***********************************************************************/

/* get a file's time and date stamp data */
getstamp(handle,filedate,filetime)
unsigned handle;  /* DOS handle for file to extract data from */
unsigned *filedate; /* ptr to variable to be passed date */
unsigned *filetime; /* ptr to variable to be paseed time */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */

  regs.al=0;
  regs.ah=0x57;  /* DOS function number */
  regs.bh= handle / 256;  /* handle goes into bx register */
  regs.bl= handle - (regs.bh*256);
  regs.ds=0; /* default ds reg. */
  regs.ds=regs.es=0; /* default es reg. */
  int_no=0x21;  /* interrupt number for DOS function call */
  ret_code = gdosint(int_no,&regs,&regs);
  *filedate = (regs.dh*256) + regs.dl; /* date returned in dx */
  *filetime = (regs.ch*256) + regs.cl; /* time returned in cx */
  return(ret_code);
}
