

;---------- MACRO DEFINITIONS
;	MACROS.INC
;**********************************************************************

COLOR_MONO   MACRO
         LOCAL CARD_OK
         PUSH DS             ;PRESERVE DATA SEGMENT WHICH IS USED BELOW
         MOV BX,BIOS_DATA    ;GET READY TO DETERMINE CARD TYPE
         MOV DS,BX           ;AND NUMBER OF COLUMNS
         MOV DX,DS:ADDR_6845 ;POINT TO CONTROLLER BASE PORT
         ADD DX,6            ;STORE ADDRESS OF STATUS PORT IN DX
         MOV AX,0B800H       ;DEFAULT TO COLOR CARD
         MOV BX,DS:EQUIP_FLAG
         AND BX,30H
         CMP BX,30H          ;IS IT MONOCHROME
         JNE CARD_OK         ;NO -CONTINUE
         MOV AX,0B000H       ;YES - SET FOR MONOCHROME
CARD_OK:
         POP DS              ;RESTORE DATA SEGMENT REGISTER
         ENDM

;**********************************************************************

;---------- WAIT FOR HORIZONTAL RETRACE
CHK_RETRACE   MACRO
         LOCAL LABEL1,LABEL2
LABEL1:
         IN AL,DX            ;GET VIDEO STATUS
         TEST AL,1           ;IS IT LOW?
         JNZ LABEL1          ;NO -KEEP CHECKING
         CLI                 ;YES - CLEAR INTERRUPTS
LABEL2:
         IN AL,DX            ;GET STATUS
         TEST AL,1           ;IS IT LOW?
         JZ LABEL2           ;NO- KEEP CHECKING
;---------- OK TO WRITE TO SCREEN NOW ( NO HASHING )
         ENDM
;
;
;***************************************************************************
