;***********************************************************************/
;*	scrtomem.asm                                                  */
;***********************************************************************/
;
INCLUDE MACROS.INC
INCLUDE BIOSDATA.INC

IFDEF MSDOS        ; DEFINED IN LATTICE 2.X M8086.MAC
PSEG

ENDIF
;
;***********************************************************************
;
;  This PROC moves a continuous string of video memory to another part
;  of memory or to an array. This is done during the horizontal retrace
;  of the video adapter to prevent flicker or 'snow'. It is called as
;  follows:
;		scrtomem(words,screen_offset,address);
;		where:
;		     int words; /* number of words to move - 16k max */
;		     int screen_offset; /* starting location on video memory*/
;		     unsigned address; /* pointer to array in either small  */
;				       /* or large models, or segment and   */
;				       /* offset combination for large data */
;				       /* models.                           */
;    		  
	ASSUME DS:NOTHING

	PUBLIC SCRTOMEM

IF @BIGMODEL+LPROG	;LARGE CODE MODELS
	SCRTOMEM  PROC	FAR
	WORDS	EQU	BP+6
	SCROFF	EQU	BP+8
	ARRAY	EQU	BP+10
ELSE
	SCRTOMEM  PROC	NEAR
	WORDS	EQU	BP+4
	SCROFF	EQU	BP+6
	ARRAY	EQU	BP+8
ENDIF

        PUSH BP             ;SAVE BP
        MOV BP,SP           ;SET BASE POINTER FOR PARAMETER LIST
	PUSH ES		    ;SAVE ES 	
        PUSH DS             ;SAVE DS
        MOV CX,[WORDS]  ;MOVE ACTUAL NUMBER OF WORDS TO MOVE INTO CX
        MOV SI,[SCROFF] ;MOVE OFFSET INTO SI

IF @BIGMODEL+LDATA  ;LARGE DATA MODELS
	LES DI,DWORD PTR [ARRAY]  ;SEGMENT AND OFFSET PASSED FOR LARGE MODEL
ELSE
	MOV DI,WORD PTR [ARRAY] ;OFFSET INTO DESTINATION REG
ENDIF

        COLOR_MONO          ;MACRO TO DETERMINE VIDEO TYPE AND PUT STATUS
                            ;PORT ADDRESS INTO DX AND VIDEO ADDRESS IN AX
        MOV DS,AX           ;POINT DS TO VIDEO CARD
        CLD                 ;SET UP AUTO INCREMENT OF SI AND DI
SCRTOMEM1:
        CHK_RETRACE         ;WAIT FOR HORIZONTAL RETRACE TO READ FROM SCREEN
        MOVSW
        LOOP SCRTOMEM1        ;LOOP TILL END OF COUNT (CX)
        STI                 ;TURN INTERRUPTS BACK ON
        POP DS              ;RESTORE DS
	POP ES 		    ;RESTORE ES     
        POP BP              ;RESTORE BP
        RET  
SCRTOMEM   ENDP

;**********************************************************************
;
IFDEF CI_C86
@CODE	ENDS

ELSE
ENDPS

ENDIF
	END
