;***********************************************************************/
;*	hgrbxfil.asm                                                  */
;***********************************************************************/
         PAGE ,132
         .SALL
;
INCLUDE MACROS.INC
INCLUDE BIOSDATA.INC

IFNDEF CI_C86      ; DEFINED IN CI-C86.INC
@BIGMODEL EQU 0    ; required for Lattice to define flag below	
PSEG               ; macro defined in Lattice xM8086.MAC file

ENDIF
;****************************************************************************
;
;	FUNCTION TO FILL A RECTANGLE WITH COLOR CALLED AS FOLLOWS:
;		GRBXFILL(ULC,ULR,LRC,LRR,COLOR);
;	WHERE:
;		INT ULC,ULR; /* UPPER LEFT COLUMN AND ROW COORDINATES */
;		INT LRC,LRR; /* LOWER RIGHT CORNER COORDINATES */
;		INT COLOR; /* COLOR VALUE FROM 0 TO 3 */


	PUBLIC	GRBXFILL

IF @BIGMODEL+LPROG    ;LARGE CODE MODELS
GRBXFILL PROC FAR
FIRST EQU 6		;OFFSET FROM BP OF FIRST VARIABLE

ELSE			; SMALL CODE MODELS
GRBXFILL PROC	NEAR
FIRST EQU 4		;OFFSET FROM BP OF FIRST VARIABLE
ENDIF

	PUSH BP
	MOV BP,SP
	PUSH BX			;SAVE BX,CX,DX,SI
	PUSH CX
	PUSH DX
	PUSH SI
	MOV BX,[BP+FIRST+4]	;GET LOWER RIGHT COLUMN
	MOV CX,[BP+FIRST]	;GET UPPER LEFT COLUMN 
	SUB BX,CX		;SUBTRACT ULC FROM LRC 
	INC BX			;ADD ONE TO GET NUMBER OF COLUMNS IN WIDTH
	PUSH BX			;SAVE NUMBER OF COLUMNS
	MOV AX,[BP+FIRST+6]	;GET LOWER RIGHT ROW
	MOV DX,[BP+FIRST+2]	;GET UPPER LEFT ROW
	PUSH DX			;SAVE STARTING ROW
	SUB AX,DX		;LRR - ULR + 1 = NUMBER OF ROWS IN LENGTH
	INC AX			
	PUSH AX 		;SAVE NUMBER OF ROWS
	PUSH AX			;AGAIN	
	MOV AL,BYTE PTR [BP+FIRST+8]	;COLOR IN AL
        MOV AH,12               ;BIOS WRITE DOT FUNCTION
;LOOP FILLING COLUMN BY COLUMN
GR01:
	PUSH AX			;SAVE AH AND AL VALUES WHICH GET DESTROYED
        INT 10H                 ;BIOS VIDEO I/O INTERRUPT
	POP AX			;RESTORE AX
	POP BX			;RETRIEVE ROWS WRITTEN COUNTER
	DEC BX			;DECREMENT FOR DOT JUST WRITTEN
	JZ GR02			;GOTO GR02 IF DONE WITH ROWS
	PUSH BX			;SAVE ROW COUNTER AGAIN
	INC DX			;NEXT ROW FOR BIOS CALL
	JMP GR01		;PLOT IT
GR02:
	POP BX			;GET ORIGINAL NUMBER OF ROWS TO PLOT
	POP DX			;GET ORIGINAL STARTING ROW
	POP SI			;GET COLUMN COUNTER
	DEC SI			;DECREMENT FOR COLUMN JUST PLOTTED
	JZ GR03			;WE ARE FINISHED IF NO MORE COLUMNS
	PUSH SI			;SAVE COLUMN COUNTER
	PUSH DX			;SAVE ORIGINAL STARTING ROW
	PUSH BX			;SAVE ROW COUNTER
	PUSH BX			;AGAIN
	INC CX			;NEXT COLUMN
	JMP GR01		;PLOT NEXT COLUMN
GR03:
	POP SI
	POP DX
	POP CX
	POP BX
	POP BP
	RET

GRBXFILL ENDP
;
;
IFDEF CI_C86
@CODE	ENDS

ELSE
ENDPS
ENDIF
	END
