;***********************************************************************/
;*	grline.asm                                                    */
;***********************************************************************/
         PAGE ,132
         .SALL
;
INCLUDE MACROS.INC
INCLUDE BIOSDATA.INC

IFDEF MSDOS        ; DEFINED IN LATTICE 2.X M8086.MAC
PSEG
ENDIF
;
;
;***********************************************************************
;
;	FUNCTION TO DRAW A LINE IN COLOR. CALLED AS FOLLOWS:
;		GRLINE(X1,Y1,X2,Y2,COLOR);
;	WHERE:
;		INT X1,Y1; /* STARTING COORDINATES */
;		INT X2,Y2; /* ENDING COORDINATES */
;		INT COLOR; /* COLOR VALUE FROM 0 TO 4 */

	PUBLIC	GRLINE

IF @BIGMODEL+LPROG    ;LARGE CODE MODELS
GRLINE PROC FAR
FIRST EQU 6		;OFFSET FROM BP OF FIRST VARIABLE

ELSE			; SMALL CODE MODELS
GRLINE	PROC	NEAR
FIRST EQU 4		;OFFSET FROM BP OF FIRST VARIABLE

ENDIF
;
;	WE WILL USE STACK FOR LOCAL STORAGE
;
DELTAX	EQU 	-2	; STORE DIFFERENCE OF X2 - X1
DELTAY	EQU     -4	; STORE DIFFERENCE OF Y2 - Y1
HALFX	EQU     -6	; STORE EITHER DELTAX OR DELTA Y DIVIDED BY 2
HALFY	EQU	-6
COUNT	EQU 	-8	;NUMBER OF DOTS DRAWN ON LINE
SAVECNT	EQU	-10	;SAVE COUNT OF DOTS WRITTEN FOR RETURN

	PUSH BP
	MOV BP,SP
;	GET ABSOLUTE VALUE OF DELTAX
	MOV AX,[BP+FIRST+4]	;GET X2
	SUB AX,[BP+FIRST]	;SUBTRACT X1 FROM IT
	MOV DI,1		;ASSUME DELTAX IS POSITIVE AND SAVE
				; X INCREMENT VALUE IN DI
	JGE PROCEED1		; CONTINUE IF POSITIVE
	MOV DI,-1		; X DECREMENT VALUE IN DI
	NEG AX			; GET ABSOLUTE VALUE
PROCEED1:
	PUSH AX			; STORE DELTAX ON STACK
;	GET ABSOLUTE VALUE OF DELTAY
	MOV AX,[BP+FIRST+6]	;GET Y2
	SUB AX,[BP+FIRST+2]	;SUBTRACT Y1 FROM IT
	MOV SI,1		;ASSUME POSITIVE DELTAY
	JGE PROCEED2		;CONTINUE IF POSITIVE
	MOV SI,-1		;DECREMENT VALUE FOR Y IN SI
	NEG AX			;GET ABSOLUTE VALUE
PROCEED2:
	PUSH AX			;SAVE DELTAY ON STACK
; SEE IF SLOPE IS GREATER THAN ONE
	CMP [BP+DELTAX],AX
	JGE  LT1			; SLOPE < 1
	JMP  GT1
; CODE FOR SLOPE LESS THAN 1
LT1:
	MOV AX,[BP+DELTAX]	;GET DELTAX AND
	SHR AX,1		;DIVIDE IT BY 2
	PUSH AX			;STORE HALFX ON STACK
	XOR BX,BX		;INITIALIZE ERROR TERM TO 0
	PUSH [BP+DELTAX]	;COUNT EQUALS DELTAX AT START, STORE IT
	PUSH [BP+DELTAX]	;SAVE COUNT FOR RETURN
	MOV CX,[BP+FIRST]	;X1 
	MOV DX,[BP+FIRST+2]	;Y1
DOTLOOP1:
	MOV AX, [BP+FIRST+8] 	; COLOR IN AX
	CALL ASMDOT 		; CALL ROUTINE TO DRAW A DOT
	ADD CX,DI		;INC/DEC X
	ADD BX,[BP+DELTAY]	;ADD DELTAY TO ERROR TERM
	CMP BX,[BP+HALFX]	;IS ERROR TERM > HALF OF DELTAX
	JLE NOCHANGE1		;DO NOT INC/DEC Y
	SUB BX,[BP+DELTAX]	;SUBTRACT DELTAX FROM ERROR TERM
	ADD DX,SI		;INC/DEC Y
NOCHANGE1:
	DEC WORD PTR [BP+COUNT]		;COUNT = COUNT - 1
	JGE DOTLOOP1		;PLOT NEXT DOT IF COUNT > 0
	JMP FINISHED
; SLOPE > 1
GT1:
	MOV AX,[BP+DELTAY]	;GET DELTAY AND
	SHR AX,1		;DIVIDE IT BY 2
	PUSH AX			;STORE IT LOCALLY
	XOR BX,BX		;INITIALIZE ERROR TERM TO 0
	PUSH [BP+DELTAY]	;COUNT OF NUMBER OF DOTS SET TO DELTAY
	PUSH [BP+DELTAY]	;SAVE COUNT FOR RETURN
	MOV CX,[BP+FIRST]	;X1 
	MOV DX,[BP+FIRST+2]	;Y1
DOTLOOP2:
	MOV AX, [BP+FIRST+8] 	; COLOR IN AX
	CALL ASMDOT 		; CALL ROUTINE TO DRAW A DOT
	ADD DX,SI		;INC/DEC Y
	ADD BX,[BP+DELTAX]	;ADD DELTAX TO ERROR TERM
	CMP BX,[BP+HALFY]	;IS ERROR TERM > HALF OF DELTAY
	JLE NOCHANGE2		;DO NOT INC/DEC X
	SUB BX,[BP+DELTAY]	;SUBTRACT DELTAY FROM ERROR TERM
	ADD CX,DI		;INC/DEC X
NOCHANGE2:
	DEC WORD PTR [BP+COUNT]		;COUNT = COUNT - 1
	JGE DOTLOOP2		;WRITE NEXT DOT IF COUNT > 0
FINISHED:
	MOV AX,[BP+SAVECNT]	;RETURN NUMBER OF DOTS WRITTEN
	ADD SP,10		;CLEAR LOCAL STORAGE
	POP BP			;RESTORE CALLER'S BP
	RET

GRLINE  ENDP
;
;****************************************************************
;
;	This function draws a colored dot in medium resolution
;	graphics mode. It is called from assembler procs as follows:
;		CX = ROW
;		DX = COLUMN
;		AX = COLOR
;

ASMDOT	PROC	NEAR

	JMP PASTDATA

BITTBL	DB	03FH,0CFH,0F3H,0FCH  ; mask to locate proper bits

COLRTBL	DB	00H,040H,080H,0C0H   ; table of color masks
	DB	00H,010H,020H,030H
	DB	00H,004H,008H,00CH
	DB	00H,001H,002H,003H

PASTDATA:
	PUSH BP			;save registers changed
	MOV BP,SP
	PUSH ES
	PUSH BX
	PUSH SI
	PUSH DI
	PUSH AX		;SAVE COLOR ON STACK FOR LATER USE
	MOV AX,0B800H	;point es to screen memory
	MOV ES,AX
	XOR DI,DI
	MOV AX,DX	 ;get row into ax and
	SHR AL,1         ;divide by two to get odd/even bit
	JNC EVENROW     ;even rows start at offset 0 and odd rows
	MOV DI,02000H   ;start at an offset 2000h 
EVENROW:
	SAL AX,1	;multiply row by 80 to get offset of correct
	SAL AX,1	;80 byte row for point
	SAL AX,1
	SAL AX,1
	MOV BX,AX
	SAL AX,1
	SAL AX,1
	ADD AX,BX	;now multiplied by 80
	ADD DI,AX	;add to odd/even offset for location in memory
	MOV AX,CX  	;get column
	MOV SI,AX	;store it in si
	SHR AX,1	;divide it by 4 to get specific byte (4 points/byte)
	SHR AX,1
	ADD DI,AX	;add to offset for exact byte - save it in di
	AND SI,03H		;mask off all bits except color bits
	MOV AL,CS:BITTBL[SI]	;get proper byte mask
	POP BX			;GET SAVED COLOR FROM STACK
	SHL SI,1		;multiply by 4 
	SHL SI,1
	ADD SI,BX		;add to color to get correct color mask
	AND AL,ES:[DI]		;mask memory byte with bit mask
	OR  AL,CS:COLRTBL[SI]	;or it with color mask
	MOV ES:[DI],AL		;move it back to memory
	POP DI		;restore original register values
	POP SI
	POP BX
	POP ES
	POP BP
	RET

ASMDOT	ENDP
;
IFDEF CI_C86

@CODE	ENDS

ELSE

ENDPS

ENDIF
	END
