;ERAFIX.ASM	COPYRIGHT 1983 BY WILLIAM M. ADNEY
;
;	Recovers an erased file
;
;	Command line: ERAFIX [d:] FILENAME.TYP
;
WBOOT	EQU	0000H	;WARM BOOT
CPM	EQU	0005H	;BDOS CALL
FCBIN	EQU	005CH	;DEFAULT FCB ADDRESS
CPMBUF	EQU	0080H	;DEFAULT CP/M BUFFER
CR	EQU	0DH	;CARRIAGE RETURN
LF	EQU	0AH	;LINE FEED
ESC	EQU	1BH	;ESCAPE
BLANK	EQU	20H	;BLANK CHARACTER
;
;
;
CRTPRT	  EQU	  9	  ;PRINT STRING ON CRT
CRTRED	  EQU	  10	  ;READ CRT INPUT LINE
CPMVSN	  EQU	  12	  ;CP/M VERSION
RESETD	  EQU	  13	  ;RESET DISK DRIVE
SLDISK	  EQU	  14	  ;SELECT DISK
FLCLOS	  EQU	  16	  ;CLOSE FILE
SFIRST	  EQU	  17	  ;SEARCH FIRST DIRECTORY ENTRY
SNEXT1	  EQU	  18	  ;SEARCH NEXT DIRECTORY ENTRY
MAKFIL	  EQU	  22	  ;MAKE FILE
SETDMA	  EQU	  26	  ;SET DMA
GETDPB	  EQU	  31	  ;GET DISK PARAMETER BLOCK
;
	ORG	100H
;
MAIN:	LXI	SP,STACK	;BEGIN THE PROGRAM-SAVE THE STACK
	LXI	D,CLS		;HEATH CLEAR SCREEN FUNCTION
	CALL	SENDLN
	LXI	D,COPYR 	;PRINT THE COPYRIGHT
	CALL	SENDLN
	JMP	GETFIL
;
;		WORKING STORAGE SECTION
;
DIRIDX: DB	0	;DIRECTORY ENTRY BUFFER INDEX
CHARCT:  DB	 0	 ;TEMP FOR COUNT OF CHARACTERS
CHR2CT:  DB	 0	 ;TEMP FOR 2ND CHARACTER
;
FCB:	DB	'?'
FLNAME: DB	0,0,0,0,0,0,0,0
FLTYPE: DB	0,0,0
EXT:	DB	0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
NR:	DB	0,0,0,0
;
CBUFF:	DB	64	;CONSOLE INPUT BUFFER
	DS	64+1
;
	DS	2*32
STACK	EQU	$
;
GETFIL:
	LXI	H,FCBIN+1	;GET THE FILENAME FROM COMMAND LINE
	MOV	A,M		;IS THE FIRST BYTE OF FILE NAME BLANK?
	CPI	BLANK
	JZ	HELP		;GET HELP SCREEN IF SO
	LXI	D,FCB+1 	;LOAD PROGRAM FCB INTO DE
	MVI	C,11		;LENGTH OF FILE NAME AND TYPE
	CALL	MOVMEM		;MOVE FILE NAME TO PROGRAM FCB
	LDA	FCBIN		;SELECT DISK
	ORA	A
	JZ	GETDP		;IF NO SELECTION, IT'S CURRENT DRIVE
	DCR	A		;OTHERWISE SELECT DISK
	MOV	E,A
	MVI	C,SLDISK
	CALL	CPM 
GETDP:				;GET DISK PARAMETERS
	MVI	A,0		;RESET DIRECTORY ENTRY BUFFER
	STA	DIRIDX
	MVI	C,CPMVSN	;CHECK FOR CP/M 2.2
	CALL	CPM 
	MOV	A,L
	ORA	A
	JZ	CPM20		;IF NOT CP/M 2.X => NOT VALID FOR PROGRAM
	MVI	C,GETDPB	;GET EXTENT MASK
	CALL	CPM 
	LXI	D,4
	DAD	D
	MOV	A,M
	CMA
	STA	CHGNMA
	LXI	D,CPMBUF	;SET DMA ADDRESS
	MVI	C,SETDMA	
	CALL	CPM 
	MVI	C,SFIRST	;SEARCH FOR FIRST DIRECTORY ENTRY
	LXI	D,FCB
	CALL	CPM
	CPI	0FFH
	JZ	NOFILE		;IF FILE NOT FOUND
CHKSTR:
	CALL	FILADR		;SET HL = FILE TABLE(FILTAB) ADDRESS
	PUSH	H		;...AND SAVE THE ADDRESS
	LXI	D,FCB+1 	;LOAD FILE NAME MATCH ADDRESS
	INX	H		;INCREMENT COUNTER
	MVI	C,11		;FILE NAME LENGTH
	CALL	COMPST		;COMPARE STRINGS
	POP	D
	JNZ	SEARCH		;IF NOT OUR FILENAME OR ZERO FLAG SET IF MATCH
	LXI	H,DIRIDX	;GET BUFFER INDEX FOR ENTRY WITH
	MOV	A,M		;...MATCHING FILE NAME
	INR	M		;ADVANCE BUFFER INDEX
	MOV	L,A		;SET HL=NEXT BUFFER INDEX
	MVI	H,0
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	DAD	H		;MULTIPLY BY 32 = FCB LENGTH
	LXI	B,FILTAB
	DAD	B
	XCHG			;SAVE THE DIRECTORY ENTRY
	MVI	C,32		;LENGTH OF DIRECTORY ENTRY
	CALL	MOVMEM		;AND MOVE TO DE
SEARCH:
	MVI	C,SNEXT1	;SEARCH FOR NEXT OCCURRENCE
	CALL	CPM 
	CPI	0FFH		;END OF DIRECTORY??
	JNZ	CHKSTR		;NO...LOOP TO END OF DIRECTORY
	LDA	DIRIDX		;CHECK FILE FOUND
	ORA	A		;...NOW THAT DIRECTORY SEARCH COMPLETED
	JZ	NOFILE		;IF FILE NOT FOUND
	CALL	CKERA		;IS THE FILE ERASED?
	JNZ	ACTIVE		;NO...THEN DON'T RESTORE IT
	CALL	CKMULT		;ARE THERE MULTIPLE ENTRIES FOR FILE??
	JNZ	MULTFL		;YES...ISSUE A WARNING
	CALL	RESTEX		;RESTORE ALL EXTENTS
ENDIT:
	MVI	C,RESETD	;RESET DISK DRIVES(ALL)
	CALL	CPM
	JMP	WBOOT		;WARMBOOT
;
;********************************
;				*
;	PROGRAM SUBROUTINES	*
;				*
;********************************
;
HELP:	LXI	D,HELPSC	;HELP SCREEN
	CALL	SENDLN
	JMP	ENDIT
;
NOFILE: LXI	D,ERROR1	;"FILE NOT FOUND"
	CALL	SENDLN
	JMP	ENDIT
;
ACTIVE: LXI	D,ERROR2	;"FILE NOT ERASED"--ACTIVE FILE
	CALL	SENDLN
	JMP	ENDIT
;
CPM20:	LXI	D,ERROR3	;"NEED CP/M 2.X"
	CALL	SENDLN
	JMP	ENDIT
;
SENDLN: MVI	C,CRTPRT	;GENERAL PRINT ROUTINE
	CALL	CPM 
	RET
;
MULTFL: LXI	D,WARNG1	;"MULTIPLE FILES FOUND" WARNING
	CALL	SENDLN		;...WITH IDENTICAL EXTENT NUMBERS
	MVI	C,CRTRED	;READ CRT RESPONSE
	LXI	D,CBUFF
	CALL	CPM 
	LDA	CBUFF+2
	ANI	5FH
	CPI	'Y'		;WAS A 'Y' (YES) INPUT??
	JNZ	ENDIT		;QUIT IF OTHER THAN 'Y' INPUT
	CALL	CHGNAM		;MODIFY ALL FILE NAMES TO UNIQUE NAME
	CALL	RESTEX		;RESTORE ALL EXTENTS
	CALL	DISPFL		;DISPLAY NEW FILE NAMES
	JMP	ENDIT
;
CHGNAM: 			;CHANGE FILE NAMES WHEN MULTIPLE
	LDA	DIRIDX		;INSERT UNIQUE 2ND CHAR INTO EACH NAME
	STA	CHARCT
	LXI	H,FILTAB+2	 ;2ND CHAR
	LXI	D,FILTAB+0CH	 ;EXTENTS CHANGED TO 00 FOR ALL
	LXI	B,32
	MVI	A,'0'
CHGNM1:
	MOV	M,A		;INSERT NEW 2ND CHAR
	INR	A		;SET 3RD FILENAME CHAR TO 'A' FOR EXT 0
	STA	CHR2CT		 ;...'B' FOR 1, ETC...
	LDAX	D		;SET 3RD CHAR = 'EXT'
	ANI	0FFH		;EXTENT MASK
CHGNMA	EQU	$-1
	ADI	'0'
	INX	H
	MOV	M,A
	DCX	H
	XRA	A		;SET EXTENT = 00
	STAX	D
	XCHG
	DAD	B
	XCHG
	DAD	B
	LDA	CHARCT
	DCR	A
	STA	CHARCT
	LDA	CHR2CT
	JNZ	CHGNM1		;LOOP OVER ALL EXTENTS
	RET
;
RESTEX:
	MVI	A,0		;RESTORE ALL EXTENTS
	STA	FCB
	LDA	DIRIDX
	MOV	C,A
	LXI	H,FILTAB+1
RESTX1:
	PUSH	B
	MVI	C,15
	LXI	D,FCB+1
	CALL	MOVMEM		;MOVE FILE NAME
	PUSH	H
	LXI	D,FCB
	MVI	C,MAKFIL	;CREATE DIRECTORY ENTRY
	CALL	CPM 
	LDA	FCB+0EH 	;CLEAR 'NOT-WRITTEN' BIT
	ANI	7FH
	STA	FCB+0EH
	POP	H		;POINTS TO RBT IMAGE
	DCX	H		;GET RECORD COUNT
	MOV	A,M
	LXI	D,FCB+15	;AND INSERT INTO FCB
	STAX	D
	INX	D
	INX	H
	MVI	C,16
	CALL	MOVMEM
	PUSH	H
	LXI	D,FCB		;CLOSE CURRENT EXTENT
	MVI	C,FLCLOS
	CALL	CPM		;TO CLOSE FILE
	POP	H
	POP	B
	INX	H
	DCR	C		;ARE WE DONE? IF NOT...
	JNZ	RESTX1		;LOOP OVER ALL EXTENTS
	RET
;
DISPFL: 			;DISPLAY THE FILE NAMES CREATED
	LXI	D,MESSG1	;"FILE NAMES CREATED:"
	CALL	SENDLN		;DISPLAY ABOVE MESSAGE
	LDA	DIRIDX
	LXI	H,FILTAB+1
DISPF1:
	PUSH	H
	STA	CHARCT
	LXI	D,MESSG2	;MOVE FILE NAME TO MESSAGE
	MVI	C,8
	CALL	MOVMEM
	INX	D		;MOVE FILE TYPE TO MESSAGE
	MVI	C,3
	CALL	MOVMEM
	LXI	D,MESSG2
	CALL	SENDLN		;PRINT FILE NAME(S) ON CRT
	POP	H
	LXI	B,32
	DAD	B
	LDA	CHARCT
	DCR	A
	JNZ	DISPF1		;LOOP FOR ALL EXTENTS
	RET
;
CKMULT: 			;CHECK MULTIPLE ERASED DIRECTORY ENTRIES
	LDA	DIRIDX		;EXIT Z = TRUE IF ONE FILE FOUNF
	MOV	C,A		;E = FILE COUNT
	LXI	H,FILTAB+0CH	 ;POINT TO EXTENT BYTES
CKMUL1:
	MOV	A,M
	CALL	FILCNT		;TO COUNT NUMBER OF IDENTICAL EXTENTS
	RNZ			;IF MULTIPLE FILES FOUND
	LXI	D,32
	DAD	D
	DCR	C
	JNZ	CKMUL1		;LOOP OVER ALL EXTENTS
	RET
;
FILCNT: 			;IDENTICAL ENTRIES COUNTED FOR FILE
	PUSH	H		;A IS THE CURRENT EXTENT
	PUSH	B		;ZERO FLAG = 1 IF ONE EXTENT FOUND
	MVI	E,0		;E IS THE EXTENT COUNT
	LXI	H,DIRIDX
	MOV	C,M
	LXI	H,FILTAB+0CH
FILCT1:
	MOV	B,M
	CMP	B
	JNZ	FILCT2		;IF NOT SAME EXTENT
	INR	E		;INCREMENT EXTENT COUNT
FILCT2:
	PUSH	D
	LXI	D,32
	DAD	D
	POP	D
	DCR	C
	JNZ	FILCT1		;LOOP OVER ALL EXTENTS
	MOV	A,E		;CHECK EXTENTS FOUND
	CPI	1
	POP	B
	POP	H
	RET
;
CKERA:				;CHECK IF FILE ERASED
	LDA	DIRIDX		;ZERO FLAG SET IF FILE ERASED
	MOV	C,A
	LXI	H,FILTAB
	LXI	D,32
CKERA1:
	MOV	A,M
	CPI	0E5H
	RNZ			;IF UNERASED EXTENT FOUND
	DAD	D
	DCR	C
	JNZ	CKERA1		;LOOP OVER ALL EXTENTS
	RET
;
FILADR: 			;DETERMINE FILE ADDRESS
	ORA	A		;A IS ADDRESS FOR FILE NAME TABLE(FILTAB)
	RAL
	RAL
	RAL
	RAL
	RAL			;MULTIPLY BY 32
	MOV	E,A
	MVI	D,0
	LXI	H,CPMBUF	;HL CONTAINS ADDRESS OF FILE TABLE(FILTAB)
	DAD	D
	RET
;
COMPST: 			;COMPARE STRINGS IN MEMORY
	LDAX	D		;ZERO FLAG SET IF STRINGS ARE EQUAL
	CMP	M
	RNZ			;IF MISMATCH 
	INX	H		;HL = STRING1 ADDRESS
	INX	D		;DE = STRING2 ADDRESS
	DCR	C		;DECREMENT LENGTH OF STRING
	JNZ	COMPST		;LOOP OVER STRING LENGTH
	RET
;
MOVMEM: 			;MOVE MEMORY
	MOV	A,M
	STAX	D
	INX	H		;HL = SOURCE ADDRESS
	INX	D		;DE = DESTINATION ADDRESS
	DCR	C		;DECREMENT BYTE COUNT IN C
	JNZ	MOVMEM		;LOOP FOR C BYTES
	RET
;
;********************************
;				*
;	MESSAGES		*
;				*
;********************************
;
CLS:	DB	ESC,'E','$'	;HEATH CLEAR SCREEN FUNCTION
;
COPYR:	DB	'                     ERAFIX PROGRAM',CR,LF,LF
	DB	'          COPYRIGHT 1983 BY WILLIAM M. ADNEY',CR,LF,'$'
;
ERROR1: DB	CR,LF,LF,LF,LF
	DB	'I can not find the file that you requested.',CR,LF
	DB	'Please check for the correct file name and type.',CR,LF
	DB	'I am returning you to CP/M.',CR,LF,LF,'$'
ERROR2: DB	CR,LF,LF,LF,LF
	DB	'The requested file is not available or is active.',CR,LF
	DB	'I am returning you to CP/M.',CR,LF,LF,'$'
ERROR3: DB	CR,LF,LF,LF,LF,LF,LF,'ERAFIX REQUIRES CP/M 2.0 OR LATER$'
;
WARNG1: DB	CR,LF,LF
	DB	'I have found multiple files with the same extent numbers.'
	DB	CR,LF,'If you enter Y to the prompt below, I will restore'
	DB	CR,LF,' all extents with new file names.'
	DB	CR,LF,'Otherwise I will return you to CP/M.'
	DB	CR,LF,LF,'Do you want me to recover all extents?'
	DB	CR,LF,'   Enter Y for YES, anything else for No : ','$'
;
MESSG1: DB	CR,LF,LF,'FILE NAMES CREATED:',CR,LF,'$'
MESSG2: DB	'        .   ',CR,LF,'$'
;
HELPSC: DB	CR,LF,LF,LF,'This program will restore ERAsed files.',CR,LF
	DB	'The command line is in the form of:',CR,LF,LF
	DB	'     ERAFIX [d:]FILENAME.TYP',CR,LF,LF
	DB	'The complete file name (with TYPe) MUST be input.',CR,LF
	DB	'The drive - [d:] - is the drive with the erased file.',CR,LF
	DB	CR,LF,'If there are identical extents with the same file',CR,LF
	DB	'I will restore them with different extents.',CR,LF
	DB	'You can recover the complete file by concatenating the',CR,LF
	DB	'desired files with the command PIP newfile=oldfile1,'
	DB	'oldfile2...etc.',CR,LF,'$'
;
	ORG	1000H		;FOR THE FILE NAME TABLE(FILTAB)
;
FILTAB	 EQU	 $


P newfile=oldfile1,'