;;;	pmmi - CIOS for MITE utility / PMMI MM-103 verison
;
;	L.E. Hughes
;
;	Mycroft Labs, Inc.
;	P.O. Box 6045
;	Tallahassee, FL 32301
;
;	(904) 385-2708

base	equ	0E0H		;base of PMMI modem board
				;Normally PMMI is addressed at 0C0 hex.
				;However this creates problems with the
				;CompuPro Disk1 controller. Thus address
				;PMMI board at 0E0 hex.
 
cr	equ	0DH		;carriage return
lf	equ	0AH		;line feed
eos	equ	'$'		;end of string
 
	org	180H

;;	jump vector
;
 
	jmp	initm
	jmp	modin
	jmp	modout
	jmp	chkrr
	jmp	chktr
	jmp	chkcd
	jmp	chkpe
	jmp	chkfe
	jmp	chkoe
	jmp	chkri
	jmp	setbr
	jmp	setpar
	jmp	set8db
	jmp	set2sb
	jmp	setorg
	jmp	setoh
	jmp	settxe
	jmp	setbrk
	jmp	dial
	jmp	tenths
	jmp	w1ms
 
;;;	initm - initialize modem
;;

initm:	mvi	a,00000000B	;initial value for CR1
	sta	cr1
	out	base+0
	mvi	a,00011111B	;initial value for CR2
	sta	cr2
	out	base+3
	ret
 
;;;	modin - input character from modem
;
;	exit:	A	character from modem
 
modin:	in	base+1		;read data port
	ret

;;;	modout - output character to modem
;
;	entry:	A	character for modem

modout:	out	base+1		;write data port
	ret
 
;;;	chkrr - check for receiver ready
;
;	exit:	c-flag	set if character available

chkrr:	in	base+0		;check status port 1
	ani	02H		;mask off data avail. bit
	rz			;exit if no data available
	stc			;exit with carry set
	ret
 
;;;	chktr - check for tranmitter ready
;
;	exit:	c-flag	set if transmitter ready

chktr:	in	base+0		;check status port 1
	ani	01H		;mask off trans. ready bit
	rz			;exit if not ready
	stc			;exit with carry set
	ret

;;	chkcd - check for carrier detect
;
;	exit:	c-flag	set if carrier present

chkcd:	in	base+2		;check status port 2
	cma			;complement it
	ani	04H		;mask off CTS bit
	rz			;exit if no carrier
	stc			;exit with carry set
	ret

;;;	chkpe - check for parity error
;
;	exit:	c-flag set if parity error
 
chkpe:	in	base+0		;check status port 0
	ani	08H		;mask off parity error bit
	rz			;exit if no parity error
	stc			;return with carry set
	ret
 
;;;	chkfe - check for frame error
;
;	exit:	c-flag set if frame error
 
chkfe:	in	base+0		;check status port 0
	ani	20H		;mask off frame error bit
	rz			;exit if no frame error
	stc			;return with carry set
	ret
 
;;;	chkoe - check for overrun error
;
;	exit:	c-flag set if overrun error
 
chkoe:	in	base+0		;check status port 0
	ani	10H		;mask off overrun error bit
	rz			;exit if no overrun error
	stc			;return with carry set
	ret
 
;;;	chkri - check for ring indicate
;
;	exit:	c-flag	set if incoming call
 
chkri:	in	base+2
	cma			;active low
	ani	02H
	rz
	stc
	ret
 
;;;	setbr - set baud rate
;
;	entry:	HL	baud rate
;
;	exit:	c-flag	set if error
 
setbr:	lxi	d,62		;error exit if baud rate < 62
	call	cmpde
	rc
	lxi	d,751		;error exit if baud rate > 750
	call	cmpde
	cmc
	rc
	shld	rate
	xchg			;move it into DE
	lxi	h,15625		;HL = 15625
	mvi	b,0		;B = 0
setbr1:	mov	a,l		;HL = HL - DE
	sub	e
	mov	l,a
	mov	a,h
	sbb	d
	mov	h,a
	jc	setbr2		;jump if negative
	inr	b		;B = B + 1
	jmp	setbr1		;loop
setbr2:	mov	a,b		;A = 15625/baud rate
	sta	brcon		;save as baud rate constant
	out	base+2		;output it to baud rate port
	lhld	rate		;fetch baud rate
	lxi	d,301		;jump if 300 or less
	call	cmpde
	jc	setbr3
	mvi	b,20H		;set RX RATE for > 300
	call	cr2off
	ora	a		;clear error flag
	ret
setbr3:	mvi	b,20H		;clear RX RATE for <= 300
	call	cr2on
	ora	a		;clear error flag
	ret
 
;;;	setpar - set parity
;
;	entry:	A	parity select code:
;				0 = NONE
;				1 = ODD
;				2 = EVEN

setpar:	ora	a		;jump if A .ne. 0
	jnz	setp1
	mvi	b,10H		;PARITY INHIBIT on
	jmp	cr1on
setp1:	dcr	a		;jump if A .ne. 1
	jnz	setp2
	mvi	b,10H		;PARITY INHIBIT off
	call	cr1off
	mvi	b,20H		;EVEN PARITY ENABLE off
	jmp	cr1off
setp2:	mvi	b,10H		;PARITY INHIBIT off
	call	cr1off
	mvi	b,20H		;EVEN PARITY ENABLE on
	jmp	cr1on

;;;	set8db - set number of data bits
;
;	entry:	A	data bits select code:
;				0 = 7 data bits
;				1 = 8 data bits

set8db:	mvi	b,08H		;NB2 on 
	call	cr1on
	ora	a		;jump if A .ne. 0
	jnz	set8d1
	mvi	b,04H		;NB1 off
	jmp	cr1off
set8d1:	mvi	b,04H		;NB1 on
	jmp	cr1on
 
;;;	set2sb - set number of stop bits
;
;	entry:	A	stop bits select code:
;				0 = 1 stop bit
;				1 = 2 stop bits
 
set2sb:	ora	a		;jump if A .ne. 0
	jnz	set2s1
	mvi	b,40H		;TWO STOP BITS off
	jmp	cr1off
set2s1:	mvi	b,40H		;TWO STOP BITS on
	jmp	cr1on
 
;;;	setorg - set modem mode (answer or originate)
;
;	entry:	A	mode select code:
;				0 = answer
;				1 = originate

setorg:	ora	a		;jump if A .ne. 0
	jnz	setor1
	mvi	b,01H		;SWITCH HOOK off
	call	cr1off
	mvi	a,02H		;RING INDICATE on
	jmp	cr1on
setor1:	mvi	b,01H		;SWITCH HOOK on
	call	cr1on
	mvi	a,02H		;RING INDICATE off
	jmp	cr1off
 
;;;	setoh - set phone "off hook"
;
;	entry:	A	hook select code:
;				0 = on hook (hung up)
;				1 = off hook
 
setoh:	ora	a		;jump if A .ne. 0
	jnz	setoh1
	mvi	b,01H		;SWITCH HOOK off
	jmp	cr1off
setoh1:	mvi	b,01H		;SWITCH HOOK on
	jmp	cr1on

;;;	settxe - set transmitter enable
;
;	entry:	A	transmitter enable code:
;				0 = disabled
;				1 = enabled
 
settxe:	ora	a		;jump if A .ne. 0 (enabled)
	jnz	settx1
	mvi	b,40H		;DTR off
	jmp	cr2off
settx1:	mvi	b,40H		;DTR on
	jmp	cr2on 
 
;;;	setbrk - set communications line break
;
;	entry:	A	break enable code:
;				0 = normal
;				1 = break
 
setbrk:	ora	a		;jump if A .ne. 0 (break)
	jnz	setbk1
	mvi	b,04H		;TX BRK NOT on
	jmp	cr2off
	mvi	b,50
setbk0:	call	w1ms
	dcr	b
	jnz	setbk0
	mvi	b,04H
	jmp	cr2on
setbk1:	mvi	b,08H		;TX BRK NOT off
	jmp	cr2off
	mvi	b,25
setbk2:	call	w1ms
	dcr	b
	jnz	setbk2
	mvi	b,08H
	jmp	cr2on

;;;	cr1on - turn on bit(s) on modem control register one
;
;	entry:	B	ones in bit position(s) to turn on

cr1on:	push	psw
	lda	cr1
	ora	b
	sta	cr1
	out	base+0
	pop	psw
	ret
 
;;;	cr1off - turn off bit(s) on modem control register one
;
;	entry:	B	ones in bit position(s) to turn off

cr1off:	push	psw
	mov	a,b
	cma
	mov	b,a
	lda	cr1
	ana	b
	sta	cr1
	out	base+0
	pop	psw
	ret
 
;;;	cr2on - turn on bit(s) on modem control register two
;
;	entry:	B	ones in bit position(s) to turn on

cr2on:	push	psw
	lda	cr2
	ora	b
	sta	cr2
	out	base+3
	pop	psw
	ret
 
;;;	cr2off - turn off bit(s) on modem control register two
;
;	entry:	B	ones in bit position(s) to turn off

cr2off:	push	psw
	mov	a,b
	cma
	mov	b,a
	lda	cr2
	ana	b
	sta	cr2
	out	base+3
	pop	psw
	ret

;;;	cmpde - compare de to hl
;
;	exit:	c-flag	set if de < hl
;		z-flag	set if de = hl

cmpde:	mov	a,h
	cmp	d
	rnz
	mov	a,l
	cmp	e
	ret
 
;;;	dial - dial phone number
;
;	entry:	HL	points to phone number, term by 0 byte

dial:	mov	a,m		;fetch next digit of number
	ora	a		;exit if zero
	jz	dialx
	inx	h		;increment pointer
	cpi	'*'		;jump if not asterisk
	jnz	dial2
	mvi	b,10		;wait 1 second
dial1:	call	tenth
	dcr	b
	jnz	dial1
	jmp	dial4		;continue
dial2:	sui	'0'		;convert ASCII to binary
	jc	dial4		;ignore if < '0'
	cpi	10		;ignore if > '9'
	jnc	dial4
	ora	a		;jump if not zero 
	jnz	dial3
	mvi	a,10		;use 10 clicks for zero
dial3:	mov	b,a		;b = number of clicks
	mvi	a,250		;constant for 10 pps
	out	base+2
	call	await0
	call	await1
dial3a:	mvi	a,1		;go off-hook
	out	base+0
	call	await0
	mvi	a,0		;go on-hook
	out	base+0
	call	await1
	dcr	b		;decrement click count
	jnz	dial3a		;loop until zero
	mvi	a,1		;go back off-hook
	out	base+0
	mvi	b,7		;interdigit wait (.7 sec)
	call	tenths
dial4:	dcr	c		;decrement digit count
	jnz	dial		;loop until zero
dialx:	lda	brcon		;reload baud rate constant
	out	base+2
	lda	cr1		;reload control reg one
	out	base+0
	mvi	a,1		;set txe on
	call	settxe
	ret

await0:	in	base+2
	ani	80H
	jnz	await0
	ret
 
await1:	in	base+2
	ani	80H
	jz	await1
	ret

;;	tenths - wait B tenths of a second
;
;	entry:	B	number of tenths of a second to wait

tenths:	call	tenth
	dcr	b
	jnz	tenths
	lda	brcon
	out	base+2
	ret
 
;;	tenth - wait 1 tenth of a second
;
 
tenth:	mvi	a,100		;constant for .1 second
tenth1:	call	w1ms
	dcr	a
	jnz	tenth1
	ret

;;	w1ms - wait one millisecond
;
 
w1ms:	push	psw
	push	h
	lxi	h,160
w1ms1:	dcx	h
	mov	a,h
	ora	l
	jnz	w1ms1
	pop	h
	pop	psw
	ret

;;	storage area
;
 
rate:	ds	2		;temp storage for baud rate
brcon:	ds	1		;baud rate constant

cr1:	ds	1		;current control register 1
cr2:	ds	1		;current control register 2

	end	pmmi
