EpImageDumping becomeDefault!

!EpImage publicMethods !

name

 "Answer the string representing the name of the receiver.
  Answer nil if no name has been set."

 ^self outputDestinations at: ##name ifAbsent: []!

name: aString

 "Set the string representing the name of the receiver to
  be aString."

 self outputDestinations at: ##name put: aString.! !

!EpImage privateMethods !

convertCompact: cm

 cm class == EsCompactMethod ifTrue: [
  uncompressedIds add: cm methodId.
  ^self copyMethod: cm compact: true].
 ^cm!

copyMethodDictionary: aDictionary

 | newDictionary |
 newDictionary := (self packagerMethodDictionaryFor: aDictionary   
methodClass)
  new: aDictionary size.
 aDictionary do: [:cm |
  | newCm |
  cm class == EsCompactMethod ifTrue: [
   uncompressedIds add: cm methodId.
   newCm := self copyMethod: cm compact: true.
  ] ifFalse: [
   newCm := cm.
  ].
  newDictionary add: newCm].
 ^newDictionary

 !

copyMethod: method compact: compact

 "Answer a copy of method, which shares the instance variables."

 | newCm literal newBct |
 (compact and: [self createIC]) ifTrue: [
  (newCm := EpCompactMethod new)
   methodId: method methodId;
   bytecodes: (EsByteCodeArray uncompressBytecodeArray: method bytecodes   
copy).
  1 to: method size do: [:i |
   (literal := method at: i) epIsBCT ifTrue: [
    newBct := self uncompressContext: literal method: newCm.
    (self templates at: newCm ifAbsentPut: [OrderedCollection new]) add:   
newBct.
    translate at: literal put: newBct.
   ].
  ].
 ] ifFalse: [
  (newCm := CompiledMethod new: method size)
   bytecodes: (EsByteCodeArray uncompressBytecodeArray: method bytecodes   
copy);
   methodClass: method methodClass;
   selector: method selector;
   filePointer: method filePointer.
  1 to: method size do: [:i |
   (literal := method at: i) epIsBCT ifTrue: [
    newBct := self uncompressContext: literal method: newCm.
    self templates notNil ifTrue: [
     (self templates at: newCm ifAbsentPut: [OrderedCollection new]) add:   
newBct].
    literal := translate at: literal put: newBct.
   ].
   newCm at: i put: literal].
  ].
 ^newCm!

templates
 "Use the name instance variable for the templates because if a new   
instance
  variable is added a new IC will have to be created, and this will   
invalidate existing
  images."

 ^name!

templates: aCollection
 "Use the name instance variable for the templates because if a new   
instance
  variable is added a new IC will have to be created, and this will   
invalidate existing
  images."

 name := aCollection.!

translateContext: bct

 | cm newCm cmSize newBct |
 (cm := bct method) class == EsCompactMethod ifTrue: [
  (uncompressedIds includes: bct epMethodContext) ifTrue: [
   newCm := (methodDictionaries at: cm methodClass) at: cm selector.
  ] ifFalse: [
   newCm := uncompressedMethods at: bct epMethodContext ifAbsentPut:   
[self copyMethod: cm compact: true].
   (translate includesKey: bct) ifTrue: [^self].
  ].
  newBct := self uncompressContext: bct method: newCm.
  self templates notNil ifTrue: [
   (self templates at: newCm ifAbsentPut: [OrderedCollection new]) add:   
newBct].
  translate at: bct put: newBct ifPresent: [
   self errorMessage: (NlsCatEPe indexedMsg: 28)].    "$NLS$ Duplicate   
replacement"
 ] ifFalse: [
  self compressCode ifTrue: [
   cmSize := cm size - (cm hasFilePointer ifTrue: [1] ifFalse: [0]).
   newBct := EsCompactBlockContextTemplate new
    methodContext: cm;
    epParent: bct parent;
    startPC: (bct climStartPC * 2 - 12) + (8 + (cmSize * 4)) // 2 - 1;
    argsAndTemps: bct climArgsAndTemps;
    yourself.
   (self templates at: cm ifAbsentPut: [OrderedCollection new]) add:   
newBct.
   translate at: bct put: newBct
    ifPresent: [self errorMessage: (NlsCatEPe indexedMsg: 28)].    "$NLS$   
Duplicate replacement"
  ] ifFalse: [self error: (NlsCatEPe indexedMsg: 55)].  "$NLS$ Invalid   
context"
 ].! !

!EpRomerImage privateMethods !

initializeDefaultSpaces

 | romSpace ramSpace |

 spaces notEmpty ifTrue: [^self].

 self compressCode ifTrue: [
  self templates: IdentityDictionary new.
  "Exclude bytecodes for code compression."
  self mapVariable: 'bytecodes' in: CompiledMethod to: Exclude].   
 "$NON-NLS$"

 ((self compressCode or: [self isEnabled: EpSetRomFlag]) and: [
  self dumperClass isSingleDependentComponent not])
 ifTrue: [
  spaces add: (romSpace := EpROMSpace new startAddress: 16r12000000;   
length: 16r2000000; name: 'ROM').  "$NON-NLS$"
  instances at: #() put: romSpace.
  self
   mapClass: (self globalNamespace classAt: #EsByteCodeArray) to:   
(EpbSpaceRule on: 'ROM');  "$NON-NLS$"
   mapClass: (self globalNamespace classAt: #Symbol) to: (EpbSpaceRule   
on: 'ROM');  "$NON-NLS$"
   mapClass: (self globalNamespace classAt: #EsAtom) to: (EpbSpaceRule   
on: 'ROM');  "$NON-NLS$"
   mapClass: (self globalNamespace classAt: #EsEmptyBlock) to:   
(EpbSpaceRule on: 'ROM');  "$NON-NLS$"
   mapClass: (self globalNamespace classAt: #TranscriptTTY) to:   
(EpbSpaceRule on: 'ROM');  "$NON-NLS$"
   mapNotExcluded: 'instVarNames' in: ClassDescription to: (EpbSpaceRule   
on: 'ROM');   "$NON-NLS$"  "$NON-NLS$"
   mapNotExcluded: 'sharedPoolNames' in: Class to: (EpbSpaceRule on:   
'ROM');   "$NON-NLS$"  "$NON-NLS$"
   mapNotExcluded: 'configurationExpression' in: SubApplication class to:   
(EpbSpaceRule on: 'ROM');   "$NON-NLS$"  "$NON-NLS$"
   mapNotExcluded: 'privileges' in: SubApplication class to:   
(EpbSpaceRule on: 'ROM');   "$NON-NLS$"  "$NON-NLS$"
   mapNotExcluded: 'seconds' in: EmTimeStamp to: (EpbSpaceRule on:   
'ROM');   "$NON-NLS$"  "$NON-NLS$"
   mapNotExcluded: 'versionName' in: EmTimeStamp to: (EpbSpaceRule on:   
'ROM');   "$NON-NLS$"  "$NON-NLS$"
   mapNotExcluded: 'strings' in: EsPoolDictionary to: (EpbSpaceRule on:   
'ROM').  "$NON-NLS$"  "$NON-NLS$"

  self compressCode ifTrue: [
   self
    mapClass: (self globalNamespace classAt: #BlockContextTemplate) to:   
(EpbSpaceRule on: 'RAM').  "$NON-NLS$"
  ].

  self createIC ifTrue: [
   romSpace priority: 2.
   self
    mapVariable: 'elements' in: Dictionary to: Given;   "$NON-NLS$"
    mapVariable: 'removedAssociations' in: EsSmalltalkDictionary to:   
Given;   "$NON-NLS$"
    mapVariable: ##default in: EsSmalltalkNamespace to: Given;
    mapVariable: 'keys' in: LookupTable to: Given;   "$NON-NLS$"
    mapVariable: 'values' in: LookupTable to: Given;   "$NON-NLS$"
    mapVariable: 'elements' in: Set to: Given;   "$NON-NLS$"
    mapVariable: ##indexed in: Array to: Given;
    mapVariable: ##indexed in: CompiledMethod to: (EpbSpaceRule on:   
'ROM');  "$NON-NLS$"
    mapClass: (self globalNamespace classAt: #Behavior) to: (EpbSpaceRule   
on: 'FIXEDRAM');  "$NON-NLS$"
    mapClass: (self globalNamespace classAt: #PlatformFunction) to:   
(EpbSpaceRule on: 'RAM');  "$NON-NLS$"
    mapNotExcluded: 'key' in: Association to: (EpbSpaceRule on: 'ROM');    
 "$NON-NLS$"  "$NON-NLS$"
    mapNotExcluded: 'elements' in: EsPoolDictionary to: (EpbSpaceRule on:   
'ROM');   "$NON-NLS$"  "$NON-NLS$"
    mapVariable: 'methodsArray' in: Behavior to: (EpbSpaceRule on:   
'ROM').   "$NON-NLS$"  "$NON-NLS$"

    spaces add: (EpRAMSpace new startAddress: 16r2A000000; length:   
16r1000000; name: 'CATEGORIES';  "$NON-NLS$"
     spaceType: EsMemoryTypeCategories | EsMemoryTypeRAM |   
EsMemoryTypeOld | EsMemoryTypeDiscardable;
     priority: 2). "Change the priority to resolve conflicts between   
category names in the CATEGORIES and EXTENSIONS spaces."
    self
     mapNotExcluded: 'categoriesArray' in: EmSelectorInformation to:   
(EpbSpaceRule on: 'CATEGORIES');   "$NON-NLS$"  "$NON-NLS$"
     mapNotExcluded: 'selectorsArray' in: EmSelectorInformation to:   
(EpbSpaceRule on: 'CATEGORIES').   "$NON-NLS$"  "$NON-NLS$"

    spaces add: (EpRAMSpace new startAddress: 16r2B000000; length:   
16r1000000; name: 'APPLICATIONS';  "$NON-NLS$"
     spaceType: EsMemoryTypeApplications | EsMemoryTypeRAM |   
EsMemoryTypeOld | EsMemoryTypeDiscardable).
    spaces add: (EpROMSpace new startAddress: 16r2C000000; length:   
16r1000000; name: 'APPROM';  "$NON-NLS$"
     spaceType: EsMemoryTypeApplications | EsMemoryTypeROM |   
EsMemoryTypeOld).

    self
     mapNotExcluded: 'sharedPoolNames' in: Class to: (EpbSpaceRule on:   
'APPROM');   "$NON-NLS$"  "$NON-NLS$"
     mapNotExcluded: 'description' in: ClassDescription to: (EpbSpaceRule   
on: 'APPLICATIONS');   "$NON-NLS$"  "$NON-NLS$"
     mapNotExcluded: 'timeStamp' in: SubApplication class to:   
(EpbSpaceRule on: 'APPLICATIONS');   "$NON-NLS$"  "$NON-NLS$"
     mapNotExcluded: 'timeStamps' in: SubApplication class to:   
(EpbSpaceRule on: 'APPLICATIONS');   "$NON-NLS$"  "$NON-NLS$"
     mapNotExcluded: 'extended' in: SubApplication class to:   
(EpbSpaceRule on: 'APPLICATIONS');   "$NON-NLS$"  "$NON-NLS$"
     mapNotExcluded: 'undefined' in: SubApplication class to:   
(EpbSpaceRule on: 'APPLICATIONS');   "$NON-NLS$"  "$NON-NLS$"
     mapNotExcluded: 'configurationExpression' in: SubApplication class   
to: (EpbSpaceRule on: 'APPROM');   "$NON-NLS$"  "$NON-NLS$"
     mapNotExcluded: 'privileges' in: SubApplication class to:   
(EpbSpaceRule on: 'APPROM');   "$NON-NLS$"  "$NON-NLS$"
     mapNotExcluded: 'dependentApplications' in: Application class to:   
(EpbSpaceRule on: 'APPLICATIONS');   "$NON-NLS$"  "$NON-NLS$"
     mapNotExcluded: 'seconds' in: EmTimeStamp to: (EpbSpaceRule on:   
'APPROM');   "$NON-NLS$"  "$NON-NLS$"
     mapNotExcluded: 'versionName' in: EmTimeStamp to: (EpbSpaceRule on:   
'APPROM').   "$NON-NLS$"  "$NON-NLS$"

" CLASSES mapNotExcluded: 'subclasses' in: Behavior to: (EpbSpaceRule on:   
'RAM');"  "$NON-NLS$"  "$NON-NLS$"
" CLASSES mapNotExcluded: 'defined' in: SubApplication class to:   
(EpbSpaceRule on: 'RAM');"  "$NON-NLS$"  "$NON-NLS$"
" CLASSES mapNotExcluded: 'subApplications' in: SubApplication class to:   
(EpbSpaceRule on: 'RAM');"   "$NON-NLS$"  "$NON-NLS$"
" CLASSES mapNotExcluded: 'prerequisites' in: Application class to:   
(EpbSpaceRule on: 'RAM');"   "$NON-NLS$"  "$NON-NLS$"
" CLASSES mapNotExcluded: 'dependentApplications' in: Application class   
to: (EpbSpaceRule on: 'RAM');"   "$NON-NLS$"  "$NON-NLS$"
  ].
 ].

 spaces add: (ramSpace := EpRAMSpace new
  startAddress: 16r28000000;
  length: 16r2000000;
  name: 'RAM';  "$NON-NLS$"
  freeFixedSpace: self freeFixedSpace).

 self compressCode ifFalse: [
  ramSpace fixedSpace spaceType: (ramSpace fixedSpace spaceType bitOr:   
EsMemoryTypeDiscardable)].! !

!EsDumper privateMethods !

compactMethods: classCounts

 | cmCount bcCount space firstIndex index target cm nextCm offset sizes   
size newCodes address |

 cmCount := classCounts at: CompiledMethod ifAbsentPut: [
  (Array new: 4) atAllPut: 0].
 bcCount := classCounts at: EsByteCodeArray ifAbsentPut: [
  (Array new: 4) atAllPut: 0].
 space := image spaceNamed: 'CODE'.  "$NON-NLS$"
 space currentAddress: space currentAddress + 1.

 index := 1.
 [index <= compiledMethods size] whileTrue: [
  firstIndex := index.
  cm := compiledMethods at: index.
  target := self convertBC: (EsByteCodeArray
   compressBytecodeArray: cm bytecodes copy meta: cm methodClass   
isMetaclass
   bigEndian: System bigEndian).
  offset := 8 + (cm size - (cm hasFilePointer ifTrue: [1] ifFalse: [0]) *   
4).
  (sizes := OrderedCollection new) add: offset.
  [
   "Break at 64K - 1 boundaries."
   ((index + 1 \\ 16rFFFF) ~= 1 and: [index < compiledMethods size])   
ifTrue: [
    nextCm := compiledMethods at: index + 1.
    newCodes := self convertBC: (EsByteCodeArray
     compressBytecodeArray: nextCm bytecodes copy meta: nextCm   
methodClass isMetaclass
     bigEndian: System bigEndian).
    size := 8 + (nextCm size - (nextCm hasFilePointer ifTrue: [1]   
ifFalse: [0]) * 4).
    (target epByteCodeEquals: newCodes) and: [offset + size <= 65536]]
   ifFalse: [false]]
  whileTrue: [
   sizes last = size ifFalse: [self error: (NlsCatEPa indexedMsg: 19)].   
 "$NLS$ Shared bytecodes with different literals size"
   sizes add: size.
   offset := offset + size.
   index := index + 1.
  ].
  firstIndex to: index - 1 do: [:i |
   size := sizes removeFirst.
   nextCm := compiledMethods at: i.
   (address := space add: nextCm ofSize: size) isNil ifTrue: [self error:   
space errorString].
   objects at: nextCm put: address.
   cmCount at: 2 put: (cmCount at: 2) + size.
   (space add: offset - 1 ofSize: 0) isNil ifTrue: [self error: space   
errorString].
   offset := offset - size.
   image templates at: nextCm ifPresent: [:templates |
    templates do: [:template |
     template markReadOnly: false.
     template startPC: template climStartPC + (offset // 2).
     template markReadOnly: true]].
  ].
  (address := space add: (compiledMethods at: index) ofSize: (size :=   
sizes removeFirst)) isNil ifTrue: [
   self error: space errorString].
  objects at: (compiledMethods at: index) put: address.
  cmCount at: 1 put: (cmCount at: 1) + index - firstIndex + 1.
  cmCount at: 2 put: (cmCount at: 2) + size.
  (space add: target ofSize: (size := target size + (4 - (target size \\   
4) \\ 4))) isNil ifTrue: [
   self error: space errorString].
  bcCount at: 1 put: (bcCount at: 1) + 1.
  bcCount at: 2 put: (bcCount at: 2) + size.
  index := index + 1.
 ].

 space currentAddress: space currentAddress - 1.! !