/*--------------------------------------------------------------------------*/
/*                                                                          */
/*  NetCentric Computing with Object Rexx                                   */
/*  Programming Example                                                     */
/*                                                                          */
/*    Kurt Maerker       Kurt_Maerker@vnet.ibm.com                          */
/*                                                              03/03/97    */
/*  Command_C.cmd  -  Session Client using TCP/IP Sockets                   */
/*                                                                          */
/*    Client program for the command server. Ask the user for a string,     */ 
/*    send the string to the server and display the result strings.         */
/*                                                                          */
/*    Parameters:                                                           */
/*      Port:   server port number                                          */
/*      Server: alias name of the server                                    */
/*                                                                          */
/*--------------------------------------------------------------------------*/

Parse Arg Port Server 
if Port = '' then Port = 1922          /* Default is command server         */

client = .tcpClient~new(Server, Port)  /* create client for server via port */

if client~connected then do            /* Is client connected to server?    */
  signal on syntax

  parse source sysinfo rest            /* get the information on platform   */ 
  client~send(sysinfo)                 /* send the platform id to server    */
                                       /* Run session until entering 'quit' */ 
  do forever
    say ""                             /* get input from user               */
    rc = client~promptInput("Please enter a command to be sent to the server") 
    if rc < 0 then leave               /* if error quit client session      */

                                       /* display the answer received       */           
    do until RetString~right(25) = ">>>End_of_transmission<<<" 
      rc = client~receive              /* receive the returned string       */
      if rc < 0 then signal syntax     /* if error terminate session        */

      RetString = client~Output        /* get the output received           */
      rr = charout(, RetString)        /* show the result                   */

      if RetString~right(20) = ">>>End_of_session<<<" then signal syntax  
    end
  end 
end

syntax:
client~shutdown                        /* shutdown client                   */
return

/****************************************************************************/

::REQUIRES "clients.frm"               /* Use the clients framework         */   

