/*--------------------------------------------------------------------------*/
/*                                                                          */
/*  NetCentric Computing with Object Rexx                                   */
/*  Programming Example                                                     */
/*                                                                          */
/*    Kurt Maerker       Kurt_Maerker@vnet.ibm.com                          */
/*                                                              03/03/97    */
/*  Chat_c.cmd  -  Session Client using TCP/IP Sockets                      */
/*                                                                          */
/*    Client program for the chat server. Ask the user for a string,        */ 
/*    send the string to the server and display the result strings.         */
/*                                                                          */
/*    Parameters:                                                           */
/*      Port:   server port number                                          */
/*      Server: alias name of the server                                    */
/*                                                                          */
/*--------------------------------------------------------------------------*/

Parse Arg Port Server 
if Port = '' then Port = 1924          /* Default is chat server            */

client = .Client~new(Server, Port)     /* create client for server via port */

if client~connected then do            /* Is client connected to server?    */
  client~listenConversation            /* display what is heard             */ 
                                       /* process session until 'quit'      */ 
  do until client~Input~word(1)~translate = 'QUIT' 
                                       /* get input from user               */
    rc = client~promptInput("Please enter a string to be sent to the server") 
    if rc < 0 then leave               /* if error quit client session      */
  end 
end

client~shutdown                        /* shutdown client                   */
return

/****************************************************************************/

::REQUIRES "clients.frm"               /* Use the clients framework         */   

/*--------------------------------------------------------------------------*/
/* Client Class definition                                                  */
/*--------------------------------------------------------------------------*/
::CLASS Client SUBCLASS tcpClient

/*--------------------------------------------------------------------------*/
::METHOD init
  expose Listening  
  use arg server, port                         

  self~init:super(server, port)
  Listening = .FALSE

/*--------------------------------------------------------------------------*/
::METHOD listenConversation UNGUARDED
  expose Listening
                                       /* Watch for any return data         */
  Listening = .TRUE
  reply         

  do while Listening
    rc = self~receive                  /* receive the returned string       */
    if rc < 0 then leave               /* if error terminate listening      */
    Say "*" self~Output                /* show what was heard               */
  end

/*--------------------------------------------------------------------------*/
::METHOD shutdown                      /* shutdown the client               */
  expose Listening
                                       /* Watch for any return data         */
  Listening = .FALSE
  self~shutdown:super

/*--------------------------------------------------------------------------*/
::METHOD uninit                        /* just in case to stop listening    */
  expose Listening
  if Listening then self~shutdown

