#include "gadgets.h"
#include "yakfont.h"
#include "xrect.h"
#include <stdlib.h>
#include <conio.h>

#define QUIT 1
#define SAVE 2

extern yakMouse mouse;

byte grid[8][16];


void drawGrid(yakFont * myYakFont)
{
  mouse.hide();

  for(int heightCounter = 0; heightCounter < myYakFont->charHeight; ++heightCounter)
    for(int widthCounter = 0; widthCounter < myYakFont->charWidth; ++widthCounter)
      x_rect_fill(widthCounter*15 +1, heightCounter*15 + 1, widthCounter*15 + 14, heightCounter*15 + 14,
		  VisiblePageOffs, (grid[widthCounter][heightCounter]) ? 15 : 0);
  mouse.show();
}

void drawFont(yakFont *myFont)
{
  mouse.hide();
  int charsInARow = 150 / (myFont->charWidth + 1);
  for(byte fontCounter = 0; fontCounter < myFont->numberOfChars; ++ fontCounter)
    x_bgprintf(150 + ((fontCounter) % charsInARow) * (myFont->charWidth + 1),
	       ((fontCounter) / charsInARow) * (myFont->charHeight + 1),
	       VisiblePageOffs, 15, 0, "%c", fontCounter + myFont->startChar);
  mouse.show();
}

void toGrid(yakFont * myFont, byte inChar)
{
  if ((inChar < myFont->startChar) || (inChar > (myFont->startChar + myFont->numberOfChars)))
    return;
  for (int heightCounter = 0; heightCounter < myFont->charHeight; ++heightCounter)
    for (int widthCounter = 0; widthCounter < 8; ++widthCounter)
      grid[widthCounter][heightCounter] = (myFont->fontData[4 + (inChar - myFont->startChar)*myFont->charHeight + heightCounter] & (1 << widthCounter)) ? 1 : 0;
}

void fromGrid(yakFont * myFont, byte outChar)
{
  if ((outChar < myFont->startChar) || (outChar > (myFont->startChar + myFont->numberOfChars)))
    return;
  for (int heightCounter = 0; heightCounter < myFont->charHeight; ++heightCounter)
  {
    myFont->fontData[4 + (outChar - myFont->startChar)*myFont->charHeight + heightCounter] = 0;
    for (int widthCounter = 0; widthCounter < 8; ++widthCounter)
      myFont->fontData[4 + (outChar - myFont->startChar)*myFont->charHeight + heightCounter] |= grid[widthCounter][heightCounter] << widthCounter;
  }
}


void zapGrid(yakFont * myYakFont, char workingChar)
{
  grid[(int)(mouse.x() / 15)][(int)(mouse.y() / 15)] = (mouse.isPressed(yakMouse::leftButton)) ? 1 : 0;
  drawGrid(myYakFont);
  fromGrid(myYakFont, workingChar);
  drawGrid(myYakFont);
  drawFont(myYakFont);
}


void main(int argCount, char **argVector)
{
  yakFont * myYakFont = NULL;
  if (argCount == 2)
    myYakFont = new yakFont(argVector[1]);
  else if (argCount == 5)
    myYakFont = new yakFont(atoi(argVector[2]), atoi(argVector[3]), atoi(argVector[4]), atoi(argVector[5]));
  else
  {
    cout << "\n\nYakFont EDitor v1.0 // 21 Nov 92 by V. Putz\nUsage: \n";
    cout << "C> yfed <filename>		to edit a font file\n";
    cout << "C> yfed <filename> <stch> <width> <height> <numchars>\n";
    cout << "     where <stch> is the ascii code of the first character,\n";
    cout << "           <width> is the width of the characters (<= 8),\n";
    cout << "           <height> is the height of the character in pixels.\n";
    cout << "       and <numchars> is the number of characters in your set.\n";
    exit(0);
  }
  x_set_mode(3,376);
  x_text_init();
  mouse.init();
  mouse.hide();
  yakLib myYakLib("draw");
  gadgetList myGadgetList;
  myGadgetList.add(new gadgetNode(new button(0,0, 0, SAVE, "sbutton", icon::normal, &myYakLib),
                   new gadgetNode(new button(0,20, 0, QUIT, "qbutton", icon::normal, &myYakLib),
                   NULL)));
  myYakFont->use();
  int charsInARow = 150 / (myYakFont->charWidth + 1);
  x_rect_fill(150,0,150 + charsInARow * (myYakFont->charWidth +1), (myYakFont->numberOfChars / charsInARow + 1) * (myYakFont->charHeight + 1),
	      VisiblePageOffs, 20);
  drawFont(myYakFont);
  x_rect_fill(0,0, (myYakFont->charWidth) * 15, (myYakFont->charHeight)*15,
		  VisiblePageOffs, 20);
  myGadgetList.draw(300,190);
  char workingChar = myYakFont->startChar;
  toGrid(myYakFont, workingChar);
  drawGrid(myYakFont);
  x_set_font(FONT_8x8);
  x_bgprintf(150,100, VisiblePageOffs, 15, 0, "  Font name: %s", argVector[1]);
  x_bgprintf(150,110, VisiblePageOffs, 15, 0, " Start char: %d", myYakFont->startChar);
  x_bgprintf(150,120, VisiblePageOffs, 15, 0, " Char Width: %d", myYakFont->charWidth);
  x_bgprintf(150,130, VisiblePageOffs, 15, 0, "Char Height: %d", myYakFont->charHeight);
  x_bgprintf(150,140, VisiblePageOffs, 15, 0, " # of Chars: %d", myYakFont->numberOfChars);
  myYakFont->use();
  int exit = 0;
  mouse.show();
  while (exit != QUIT)
  {
    exit = myGadgetList.status();
    if (kbhit())
    {
      char tempChar = getch();
      fromGrid(myYakFont, workingChar);
      workingChar = ((tempChar < myYakFont->startChar) || (tempChar > (myYakFont->startChar + myYakFont->numberOfChars))) ?
		    workingChar:
		    tempChar;
      toGrid(myYakFont, workingChar);
      drawGrid(myYakFont);
    }
    if (mouse.isInBox(0,0,myYakFont->charWidth*15, (myYakFont->charHeight)*15)
     &&(mouse.isPressed(yakMouse::eitherButton)))
      zapGrid(myYakFont, workingChar);
    if (mouse.isInBox(150,0,150 + charsInARow * (myYakFont->charWidth +1), (myYakFont->numberOfChars / charsInARow + 1) * (myYakFont->charHeight + 1))
     &&(mouse.isPressed(yakMouse::leftButton)))
    {
      char tempChar = myYakFont->startChar +(charsInARow*(int)(mouse.y()/(myYakFont->charHeight + 1)) + (int)(mouse.x() - 150)/(myYakFont->charWidth + 1));
      fromGrid(myYakFont, workingChar);
      workingChar = ((tempChar < myYakFont->startChar) || (tempChar > (myYakFont->startChar + myYakFont->numberOfChars))) ?
		    workingChar:
		    tempChar;
      toGrid(myYakFont, workingChar);
      drawGrid(myYakFont);
    }
    if (exit == SAVE)
      myYakFont->save(argVector[1]);
  }
  mouse.remove();
  x_text_mode();
}