// OzGKS.cpp : GKS implementation for windows.
//
// NOTE turn on //TRACE for desperation debugging!!!
//
//    a limited single device implementation of the gks
//    graphic standard to support single devices for ozgis
//
//    refer to the gks standard report.
//    mods
//
//    july 92 - original
//    Feb 93 - text sizes
//    May 93 vector array dynamically allocated!
//    June 93 - reading Pixel value
//	  May 97 - 32 bit MFC version
//	  Nov 97 - text params to save calculation, apply aspect to CLIP
//    May 98 - dont zap clip region

#include "stdafx.h"

#include "OzAPIDoc.h"
#include "OzAPIView.h"
#include "gksObject.h"
#include "gksSegment.h"
#include "gksLine.h"
#include "gksText.h"
#include "gksMarker.h"
#include "gksPolygon.h"
#include "gksViewport.h"
#include "gksWindow.h"
#include "gksCursor.h"
#include "gksBoxCursor.h"
#include "gksFixedBoxCursor.h"
#include "gksLineCursor.h"
#include "gksCircleCursor.h"
#include "gksDigitiseCursor.h"
#include "OzGKS.h"


static void  SetWindVP();
static void FitWindow(CRect* rectWin);


/// The drawing data

CgksSegment	segment[NUM_SEGS];	// the graphics segments
int	nowSegment = 0;				// the currently selected segment


//  GKS status 

int polyInteriorStyle=1;	  //fill area interior style  1=solid,2=pattern,3=hatch
int polyColourIndex=3;       //fill area colour index

BOOL clippingFlag=FALSE;       // indicator, 0=none, 1=clip
BOOL pickableFlag=FALSE;       // indicator, 0=none, 1=clip

int lineType=0;      // line-type
char markerType=1;      // marker type

float markerSize = 1.0;	// marker size

int	lineWidth = 1;		// line width

int lineColourIndex=2;       // polyline colour index
int markerColourIndex=2;       // polymarker colour index
int textColourIndex=2;       // text colour index

int currentFont=1;			// selected font number
int fontPtrecision=1;       // font precision
float charExpansion=0.5;  // char expansion factor
float worldCharHt = 1.0;	// char height in world coords
//int charHeight = 8;       // current font char width requested
//int charWidth  = 6;       // current font char height
int textPath=0;       // text path   0=right, 3=down
int textAlignHoriz=1;      // text alignment horizontal, 1=left, 2=centre
int textAlignVert=4;       // text alignment vertical, 1=top, 4=base
char fontFace[NUM_FONTS+1][50];	// ladst font is for markers



//  windows & viewports - for transforming user coords -> device

BOOL	needTransform = TRUE;		// if need to convert coords at paint
float wind[] = {0.0,1.0,0.0,0.75};
float vp[] = {0.0,1.0,0.0,0.75};
float userWindow[] = {0.0,1.0,0.0,0.75};
float userViewport[] = {0.0,1.0,0.0,0.75};
float workstationWindow[] = {0.0,639.0,0.0,479.0};
float workstationViewport[] = {0.0,1.0,0.0,0.75};
float xwvp = 1.0;
float ywvp = 0.75;
float xndc = 1.0;
float yndc = 0.75;
float xoff = 0.0;
float yoff = 0.0;
float aspect = 0.75; // aspect  Y/X 
int   ySwap = 479;
BOOL wantAspect = TRUE;

// window status params

int		iRasterCaps;   /* Raster capabilities		      */
int		iPalSize;      /* Size of Physical palette      */
int		iReserved;		// no reserved in palette
int     colorres;      // number of bits per pixel
WORD	xScreen;       /* Screen size  */
WORD	yScreen;       /* Screen size  */
WORD	nXBorder;      /* Width of window border	      */
WORD	nYBorder;      /* Width of window border	      */
WORD	nXTitle;       /* Width of title bar		      */
WORD	nYTitle;       /* Height of title bar		   */

// OzAPI

COzAPIDoc* theDoc=NULL;
COzAPIView* theView=NULL;
CWnd* gksWND=NULL;     // drawing window
LOGPALETTE*	logPal;    //  program's logical palette, points to following
struct palette			// mimics LOGPALETTE
{
	WORD			palVersion;
	WORD			palNumEntries;
	PALETTEENTRY	palPalEntry[PALSIZE];
}	thePalette;

//int		noLut=235;			// Number of colors supported by device 
BOOL	VGA256;				// pallette handling different
WORD	noXpix=640;        // Width of the application window      
WORD	noYpix=480;        // Height of the application window    
CRect	rectWin;			// current window extent 
//TEXTMETRIC      textmetric;


long Xloc,Yloc;    // locator (Xhair) current posn





/*************************************************************************


  Called from doc at start 


*****************************************************************/


void	GKSinit ( COzAPIDoc* pDoc)

{
	int	idx, i;
	theDoc = pDoc;

	// start palette
	logPal = (LOGPALETTE*) &thePalette;
	logPal->palNumEntries = (WORD)PALSIZE; // reset later
    logPal->palVersion    = (WORD)0x0300;
	for(idx=0; idx < PALSIZE; idx++)
	{
		logPal->palPalEntry[idx].peRed   = (BYTE)idx;
		logPal->palPalEntry[idx].peGreen = (BYTE)idx;
		logPal->palPalEntry[idx].peBlue  = (BYTE)0;
		logPal->palPalEntry[idx].peFlags = NULL;
	}

	// intialise fonts

	for (i=0; i<NUM_FONTS; i++)
		strcpy(fontFace[i], "System");
	strcpy (fontFace[NUM_FONTS], "Wingdings");

}


/************************************************************************


  Select drawing object into DC. Called from the objects as they
  draw themselves.

  Here so can check if already have wot is wanted

***************************************************************************/

//  current settings

	int		now_lineType;
	int		now_lineWidth;
	int		now_lineColour;
	int		now_brushColour;
	int		now_fillType;
	int		now_textColour;
	int		now_rectColour;
	int		now_font;
	int		now_charHeightPixels;
	float	now_charHeight;
	float	now_charExpand;
	int		now_horizontal;
	int		now_vertical;
	CPen*	pPen=NULL;
	CPen*	pOldPen=NULL;
	CFont*	pFont=NULL;
	CFont*	pOldFont=NULL;	// all these GDI objects have to be deleted from context
	CBrush*	pBrush=NULL;
	CBrush*	pOldBrush=NULL;
	CPalette* pOldPalette=NULL;
	CRgn*	clipRegion = NULL;
	UINT	numRealized;
	float	store_vp[4],store_wind[4];
	BOOL	store_clip;






static void ZapDrawingObjects () 
{

	if (pPen)
	{
		delete pPen;			// zap any drawing objects
		pPen = NULL;
	}
	if (pBrush)
	{
		delete pBrush;
		pBrush = NULL;
	}
	if (pFont)
	{
		delete pFont;
		pFont = NULL;
	}
      /**************** may 98
	if (clipRegion)
	{
		delete clipRegion;
		clipRegion = NULL;
	}
      ****************/
	return;
}


static void PrepareForDrawing(CDC* pDC, CPalette* gksPalette)

{
	MoveFloat(userViewport, store_vp, 4);
	MoveFloat(userWindow, store_wind, 4);
	store_clip = clippingFlag;
	now_lineType = 0;
	now_lineWidth = 0;
	now_lineColour = 0;
	now_brushColour = 0;
	now_textColour = 0;
	now_rectColour = 0;
	now_fillType = 0;
	now_font = 0;
	now_charHeight = 0.0;
	now_charHeightPixels = 0;
	now_charExpand = 0.0;
	now_horizontal = 0;
	now_vertical = 0;

// set up palette with current colours

	CreateGKSPalette(gksPalette);
	pOldPalette = pDC->SelectPalette( gksPalette, FALSE );
	numRealized = pDC->RealizePalette();
	pDC->SetBkColor(PALETTEINDEX(0));

}


static void RestoreAfterDrawing(CDC* pDC, CPalette* gksPalette)

{
	MoveFloat(store_vp, userViewport, 4);
	MoveFloat(store_wind, userWindow, 4);
	clippingFlag = store_clip;
	SetWindVP();
	if (pOldPen)
		pDC->SelectObject(pOldPen);	// deselects the current objects
	if (pOldFont)
		pDC->SelectObject(pOldFont);
	if (pOldBrush)
		pDC->SelectObject(pOldBrush);
	pOldPen = NULL;
	pOldFont = NULL;
	pOldBrush = NULL;
	ZapDrawingObjects();

	pDC->SelectPalette(pOldPalette, TRUE);
	gksPalette->DeleteObject();

}

void  GKStransf(CDC* pDC, float* viewport, float* window, BOOL clipOn)
{
	MoveFloat(viewport, userViewport, 4);
	MoveFloat(window, userWindow, 4);
	clippingFlag = clipOn;
	SetWindVP();
	pDC->SelectClipRgn (clipRegion);
}

void  GKSpen(CDC* pDC, int lineType, int lineWidth, int lineColour)

{
	if (lineType != now_lineType || lineWidth != now_lineWidth || 
			lineColour != now_lineColour)
	{
		now_lineType = lineType;
		now_lineWidth = lineWidth;
		now_lineColour = lineColour;
		if (pPen)
		{
			pDC->SelectObject(pOldPen);
			delete pPen;
		}
		pPen = new CPen;
		if (!pPen)
			GKSfatalError ("Couldnt allocate pen");
		if (!pPen->CreatePen(lineType, lineWidth, GKScolour(lineColour)) )
			GKSfatalError ("Couldnt create pen");
		if (!pOldPen)  // store original DC pen at very start
			pOldPen = pDC->SelectObject(pPen);
		else
			pDC->SelectObject(pPen);
	}

}

void  GKSbrush(CDC* pDC, int fillType, int fillColour)

{
	int	type;
	int	stat=-1;

	if (now_brushColour != fillColour || now_fillType != fillType )
	{
		now_brushColour = fillColour;
		now_fillType = fillType;
		if (pBrush)
		{
			pDC->SelectObject(pOldBrush);
			delete pBrush;
		}
		pBrush = new CBrush;
		if (!pBrush)
			GKSfatalError ("Couldnt allocate brush");

		if (fillType == 2)
			stat = pBrush->CreateHatchBrush(HS_BDIAGONAL, GKScolour(fillColour));
		else if (fillType == 3)
			stat = pBrush->CreateHatchBrush(HS_CROSS, GKScolour(fillColour));
		else if (fillType == 4)
			stat = pBrush->CreateHatchBrush(HS_DIAGCROSS, GKScolour(fillColour));
		else if (fillType == 5)
			stat = pBrush->CreateHatchBrush(HS_FDIAGONAL, GKScolour(fillColour));
		else if (fillType == 6)
			stat = pBrush->CreateHatchBrush(HS_HORIZONTAL, GKScolour(fillColour));
		else if (fillType == 7)
			stat = pBrush->CreateHatchBrush(HS_VERTICAL, GKScolour(fillColour));
		else 
			stat = pBrush->CreateSolidBrush(GKScolour(fillColour));

		if (stat == 0)
				GKSfatalError ("Couldnt create Brush");

		if (!pOldBrush)  // store original DC Brush at very start
			pOldBrush = pDC->SelectObject(pBrush);
		else
			pDC->SelectObject(pBrush);
	}

}

// set up text, returns char height in pixels

int	GKStext(CDC* pDC, float charHt, float charExpand, int horizontal, int vertical, 
				int font, int colour, BOOL ndc)
{
	WORD wFlags;
	BYTE	nCharSet;
	int		height, width;


	if (now_font != font || now_charHeight != charHt || now_charExpand != charExpand)
	{
		// calculate char size in pixels

		if (ndc) // size in NDC i.e. marker
		{
			height = xndc * charHt + 0.5;
			width = height;
		}
		else
		{
			height = yndc * ywvp * charHt + 0.5;
			width = charExpand * height  - 0.5;  // 1 less for space in between
		}
		now_charHeightPixels = height;
		// set up font

		now_font = font;
		now_charHeight = charHt; // save calculating each time
		now_charExpand = charExpand;
		if (pFont)
		{
			pDC->SelectObject(pOldFont);
			delete pFont;
		}
		pFont = new CFont;
		if (!pFont)
			GKSfatalError ("Couldnt allocate font");
		if (font == NUM_FONTS) // marker font
			nCharSet = SYMBOL_CHARSET;
		else
			nCharSet = ANSI_CHARSET;
		if (!pFont->CreateFont(height, width, 0,
							0, FW_DONTCARE, FALSE, FALSE,
							FALSE, nCharSet, OUT_TT_PRECIS,
							CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, 
							DEFAULT_PITCH || FF_DONTCARE, 
							fontFace[font-1]) )
			GKSfatalError ("Couldnt create Font");
		if (!pOldFont)  // store original DC Font at very start
			pOldFont = pDC->SelectObject(pFont);
		else
			pDC->SelectObject(pFont);
		now_textColour = 0;
		now_horizontal = 0;
		now_vertical = 0;
	}

	// text characteristics

	if (now_textColour != colour || now_horizontal != horizontal ||
		now_vertical != vertical)
	{
		now_textColour = colour;
		now_horizontal = horizontal;
		now_vertical = vertical;
		wFlags = 0;
		if (horizontal == 2)
		 wFlags |= TA_CENTER;
		else if (horizontal == 3)
		 wFlags |= TA_RIGHT;
		else
		 wFlags |= TA_LEFT;

		if (vertical == 1)
			 wFlags |= TA_TOP;
		else
			wFlags |= TA_BASELINE;
		pDC->SetTextAlign(wFlags);
		pDC->SetTextColor(GKScolour(colour));
		pDC->SetBkMode(TRANSPARENT);
	}

		return (now_charHeightPixels);

}

/*************************************************************************


  Called from view to draw  everything on screen


*****************************************************************/


void	GKSonDraw ( COzAPIDoc* pDoc, COzAPIView* pView, CDC* pDC, 
				   BOOL m_firstDraw)

{
	CPaintDC*	paintDC;
	int seg;
	CRect	oldRect;
	CPalette gksPalette;
	theDoc = pDoc;
	theView = pView;

	paintDC = (CPaintDC*)pDC;

	if (m_firstDraw)
	{
		needTransform = TRUE;
	}


//
//    put screen params into global area

	gksWND = AfxGetMainWnd();

    xScreen	 = GetSystemMetrics (SM_CXSCREEN);
    yScreen	 = GetSystemMetrics (SM_CYSCREEN);
    nXBorder	 = GetSystemMetrics (SM_CXFRAME);
    nYBorder	 = GetSystemMetrics (SM_CYFRAME);
    nXTitle	 = GetSystemMetrics (SM_CXSIZE);
    nYTitle	 = GetSystemMetrics (SM_CYSIZE);

    iPalSize	 = pDC->GetDeviceCaps (SIZEPALETTE); // system palette size
    if (iPalSize>128)
      VGA256 = TRUE;
    else
      VGA256 = FALSE;
    iReserved = pDC->GetDeviceCaps(NUMRESERVED);
	//noLut = iPalSize - iReserved;
	//if (noLut > PALSIZE)
	//	noLut = PALSIZE;
    colorres	 = pDC->GetDeviceCaps (COLORRES);    // bits per pixel
    iRasterCaps = pDC->GetDeviceCaps (RASTERCAPS);
    iRasterCaps = (iRasterCaps & RC_PALETTE) ? TRUE : FALSE;


// transform to fit the client rect = window size

	oldRect = rectWin;
	gksWND->GetClientRect (&rectWin);
	//Dec97rectWin = paintDC->m_ps.rcPaint;
	rectWin.bottom -= nYBorder;
	rectWin.right -= nXBorder;
	if (rectWin != oldRect)
		needTransform = TRUE;
	FitWindow(&rectWin);

// initialise

	PrepareForDrawing(pDC, &gksPalette);
	

// draw rectangle on screen in background colour

	GKSbrush(pDC, 1, 0);
	pDC->FillRect(&rectWin, pBrush);

// now draw all segs

	for (seg=0; seg<NUM_SEGS; seg++)
	{
		//TRACE("DRAW SEG %d \n",seg);
		segment[seg].DrawAll(pDC, needTransform);
	}

// restore

	RestoreAfterDrawing(pDC, &gksPalette);


return;

}


/*************************************************************************


  Called from view to print  everything on screen


*****************************************************************/


void	GKSonPrint ( COzAPIDoc* pDoc, COzAPIView* pView, CDC* pDC, CPrintInfo *pInfo)

{
	int seg;
	CRect	printerRect;
	CPalette gksPalette;
	theDoc = pDoc;
	theView = pView;




// transform to fit the client rect = window size

	printerRect = pInfo->m_rectDraw;
	needTransform = TRUE;
	FitWindow(&printerRect);


// initialise

	PrepareForDrawing(pDC, &gksPalette);

// now draw all segs

	for (seg=0; seg<NUM_SEGS; seg++)
	{
		segment[seg].DrawAll(pDC, needTransform);
	}

// restore for screen

	RestoreAfterDrawing(pDC, &gksPalette);
	
	gksWND->GetClientRect (&rectWin);
	needTransform = TRUE;
	FitWindow(&rectWin);


return;


}

/*************************************************************************


  Called from view to handle cursors


*****************************************************************/

CgksCursor*	pCursor=NULL;	// current cursor
CClientDC*	pCursorDC=NULL;	// for drawing cursor shape

// one call cursor selection

float*	xCursor = NULL;
float*	yCursor = NULL;
long	numCursor;
float	radiusCursor;
BOOL	gotCursor = TRUE;



void InitLocator (long newType, float* initial, long handle, BOOL doCallback)
{
	gotCursor = FALSE;
	if (pCursor)
		delete (pCursor);
	pCursor = NULL;
	if (pCursorDC)
		delete (pCursorDC);
	pCursorDC = NULL;

	switch (newType)
	{
		case 1:
		pCursor = new CgksCursor(newType, initial, handle, doCallback);
		break;
		case 2:
		pCursor = new CgksBoxCursor(newType, initial, handle, doCallback);
		break;
		case 3:
		pCursor = new CgksCircleCursor(newType, initial, handle, doCallback);
		break;
		case 4:
		pCursor = new CgksLineCursor(newType, initial, handle, doCallback);
		break;
		case 5:
		pCursor = new CgksFixedBoxCursor(newType, initial, handle, doCallback);
		break;
		case 6:
		pCursor = new CgksDigitiseCursor(newType, initial, handle, doCallback);
		break;
	}

	if (newType > 1)
		pCursorDC = new CClientDC(gksWND);

}

void GKSonLButtonDown(CPoint point)
{
	if (pCursor)
		pCursor->ButtonDown(pCursorDC, point);
}
void GKSonLButtonUp(CPoint point)
{
	if (pCursor)
		pCursor->ButtonUp(pCursorDC, point);
}
void GKSonMouseMove(CPoint point)
{
	if (pCursor)
		pCursor->MouseMove(pCursorDC, point);
}


// called for one time cursor with selection

void GKScursorResults(long num, float* x, float* y, float extra)
{
	InitLocator(0, NULL, 0, TRUE);  // kill locator
	numCursor = num;
	if (xCursor) // previous results
	{
		delete [] xCursor;
		delete [] yCursor;
	}
	xCursor = x;
	yCursor = y;
	radiusCursor = extra;
	gotCursor = TRUE;   // reset flag 
}


/************************************************************************

	TRANSFORMATIONS

***********************************************************************/



void  xw2dev (float x, long* xdev)
//    ==========================

//    convert x in window to device posn

{
float v;


v     = xndc * (xoff + xwvp * (x-wind[0]) );
*xdev =  v + 0.5;

//TRACE("xw2dev %f %d \n",x,*xdev);

return;
}

void  xdev2w (float* x, long xdev)
//    ==========================

//    convert x in  device posn to window

{
float v;

*x = xdev / xndc ;
*x = *x - xoff;
*x = *x / xwvp + wind[0];
//TRACE("xdev2w %f %d \n",*x,xdev);
return;
}


void  yw2dev (float y, long* ydev)
//    ===========================

//    convert y in window to device posn


{
float v;


v     = yndc * (yoff + ywvp * (y-wind[2]) );
*ydev = ySwap - (v + 0.5);  // invert
//TRACE("yw2dev %f %d \n",y,*ydev);
return;
}


void  ydev2w (float* y, long ydev)
//    ==========================

//    convert y in  device posn to window

{
float v;
*y = ySwap - ydev;
*y =  *y / yndc;
*y = *y - yoff;
*y = *y / ywvp + wind[2];
//TRACE("ydev2w %f %d \n",*y,ydev); 
return;
}


// return scaling from world to pixels for finding box cursor widths etc

void	World2Pixels(float* xScale, float* yScale)
{
		*xScale = xndc * xwvp;
		*yScale = yndc * ywvp;
}

//  calculate pixel extent & swapping to fit aspect into window

static void FitWindow(CRect* rectWin)
{
	int xPix, yPix;
	float ratio;

	xPix = rectWin->right - rectWin->left + 1; 
	yPix = rectWin->bottom - rectWin->top + 1; 
	ratio = (float)yPix / (float)xPix;
	//TRACE("FitWindow xPix %d yPix %d ratio %f \n", xPix, yPix, ratio);
	/****** fixed at 0.75
	if (wantAspect)
	{
		aspect = ratio;		// reset when reqd
		//TRACE("FitWindow new aspect %f\n", aspect);
		wantAspect = FALSE;
	} 
	******************/
	if (ratio > aspect)  // Y longer, exact fit X
	{
		noXpix = xPix;
		noYpix = aspect * xPix + 0.5;
	}
	else
	{
		noXpix = yPix / aspect + 0.5;
		noYpix = yPix;
	}
	//ySwap= (yPix+noYpix)/2 - 1; // centre in Y
	ySwap = noYpix;
}

//    set window & viewport parameters

static void  SetWindVP()
//    =================

{
float  fact,off;
int    pix;
float clippingWindow[4];
int minpxx,maxpxx,minpxy,maxpxy; // clipping pixels extent


// workstation window and viewport now set to drawing window size

workstationViewport[0] = 0;
workstationViewport[1] = noXpix - 1;	// viewport is pixels
workstationViewport[2] = 0;
workstationViewport[3] = noYpix - 1;
//workstationViewport[3] = aspect * workstationViewport[1];

workstationWindow[0] = 0;
workstationWindow[1] = 1.0;	// window is NDC
workstationWindow[2] = 0;
workstationWindow[3] = aspect;

//TRACE("!!!!!SetWindVP \n");

//TRACE(" noXpix %d  noYpix %d aspect %f ySwap %d\n", noXpix, noYpix, aspect, ySwap);


//TRACE("userWindow %f %f %f %f\n",userWindow[0],userWindow[1],userWindow[2],userWindow[3]);
//TRACE("userViewport %f %f %f %f\n",userViewport[0],userViewport[1],userViewport[2],userViewport[3]);
//TRACE("workstationWindow %f %f %f %f\n",workstationWindow[0],workstationWindow[1],workstationWindow[2],workstationWindow[3]);
//TRACE("workstationViewport %f %f %f %f\n",workstationViewport[0],workstationViewport[1],workstationViewport[2],workstationViewport[3]);

//  clipping window

fact = (userWindow[1]-userWindow[0]) / (userViewport[1]-userViewport[0]);
off = fact * userViewport[0];
clippingWindow[0] = userWindow[0] + off;
off = fact * (workstationWindow[1]-userViewport[1]);
clippingWindow[1] = userWindow[1] + off;
 
fact = (userWindow[3]-userWindow[2]) / (userViewport[3]-userViewport[2]);
off = fact * (workstationWindow[2]-userViewport[2]);
clippingWindow[2] = userWindow[2] + off;
off = fact * (workstationWindow[3]-userViewport[3]);
clippingWindow[3] = userWindow[3] + off;

//TRACE("clippingWindow %f %f %f %f\n",clippingWindow[0],clippingWindow[1],clippingWindow[2],clippingWindow[3]);

//  current windows
/********************************************
if (clippingFlag == 1) // clipping
      {
      MoveFloat (userWindow,wind,4);
      MoveFloat (userViewport,vp,4);
      }
else
      {
      MoveFloat (clippingWindow,wind,4);
      MoveFloat (workstationWindow,vp,4);
      }
************************/
MoveFloat (userWindow,wind,4);
MoveFloat (userViewport,vp,4);
//TRACE("wind %f %f %f %f\n",wind[0],wind[1],wind[2],wind[3]);
//TRACE("vp %f %f %f %f\n",vp[0],vp[1],vp[2],vp[3]);

xwvp = (vp[1]-vp[0]) / (wind[1]-wind[0]);
ywvp = (vp[3]-vp[2]) / (wind[3]-wind[2]);
xoff = vp[0] - workstationViewport[0];
yoff = vp[2] - workstationViewport[2];
xndc = (workstationViewport[1]-workstationViewport[0]) / (workstationWindow[1]-workstationWindow[0]);
yndc = (workstationViewport[3]-workstationViewport[2]) / (workstationWindow[3]-workstationWindow[2]);
//TRACE("xwvp,ywvp %f %f xoff,yoff %f %f xndc,yndc %f %f\n",xwvp,ywvp,xoff,yoff,xndc,yndc);

//  drawing pixel limits 

if (clipRegion)
{
   clipRegion->DeleteObject();
   delete clipRegion;
   clipRegion = NULL;
}
if (clippingFlag == 1) // clipping
      {
      pix = noXpix - 1;
      minpxx = pix * vp[0] + 0.5;
      maxpxx = pix * vp[1] + 0.5;
      pix = noYpix - 1;
      minpxy = pix * vp[2] / aspect + 0.5;
      maxpxy = pix * vp[3] / aspect + 0.5;
 //nov97     minpxy = pix * vp[2] + 0.5;
 //     maxpxy = pix * vp[3] + 0.5;
	  clipRegion = new CRgn;
	  clipRegion->CreateRectRgn (minpxx,noYpix-maxpxy,maxpxx,noYpix-minpxy);
 //TRACE("CLIP %d %d %d %d\n",minpxx,minpxy,maxpxx,maxpxy);
     }
else    // all screen, region is null
      {
      //minpxx = 0;
      //minpxy = 0;
      //maxpxx = noXpix - 1; // any bigger fouls printer
      //maxpxy = noYpix - 1;
      }

return;
}






//$$$$$$$$$$$$$$$$$ general $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$


void GKSfatalError (char* text)
{
	AfxMessageBox(text, MB_OK|MB_ICONSTOP);
	AfxAbort();
	exit(-1);
}



void MoveFloat (float* in, float* out, int num)
//==========================

{
int i;
for (i=0; i<num; i++)
    out[i] = in[i];

return;
}


//%%%%%%%%%%%%%%%% colours %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

// return the windoze RGB value from a palette location

COLORREF GKScolour(int idx)
{
	COLORREF retCol;
	retCol = RGB(logPal->palPalEntry[idx].peRed, logPal->palPalEntry[idx].peGreen ,logPal->palPalEntry[idx].peBlue);
	retCol = PALETTEINDEX(idx);
	return (retCol);
}



// create the current palette ready to draw

static void CreateGKSPalette(CPalette* gksPalette)
{
	int stat;

//	if (VGA256==TRUE) // put system colours in top
//    {
//		stat = GetSystemPaletteEntries(pDC->m_hDC, 0, 20, &logPal->pallogPal->palpalPalEntry[235]);
 //   }
//	logPal->palNumEntries = (WORD)noLut;
	logPal->palNumEntries = PALSIZE;
	stat = gksPalette->CreatePalette(logPal);
}

void  set_lut (int lut,float cr,float cg,float cb)
//    ==========================
 
//    set LUT array value

// int  lut;  // colour index, 0,1,....
// float cr;    // red value
// float cg;    // green, (0.0-1.0)
// float cb;    // blue

{
BYTE     ired,iblue,igreen;


ired   = 255.0 *  cr + 0.5;
iblue  = 255.0 *  cb + 0.5;
igreen = 255.0 *  cg + 0.5;



if (lut>PALSIZE)  // too many entries
    return;

logPal->palPalEntry[lut].peRed  = ired;
logPal->palPalEntry[lut].peGreen  = igreen;
logPal->palPalEntry[lut].peBlue  = iblue;
logPal->palPalEntry[lut].peFlags  = NULL;

}


//
// $$$$$$$$$$$$$$$$$$$ control functions$$$$$$$$$$$$$$$$$$$
//
extern "C" void gopks ()
//    =========================
//
//    open gks
{
	return;
}






extern "C" void gclks ()
//    ==========================
//
//    close gks
//
{
	int	seg;
	for (seg=0; seg<NUM_SEGS; seg++)	// clear segments
		segment[seg].Clear();
	InitLocator(0, NULL, 0, TRUE);	// kill any cursor

	ZapDrawingObjects();

	return;
}


extern "C" void gopwk (long* wkid, long* conid, long* wtype)
//    ==========================
//
//    open workstation
//      long *wkid;   // workstation ident
//      long *conid;   // connection id (lun)
//      long *wtype;   // workstation type,0=output, 2=input-output
{

return;
}




extern "C" void gclwk (long* wkid)
//    ==========================
//
//    close workstation
//      long *wkid; // workstation id
//
{

	int	seg;
	for (seg=0; seg<NUM_SEGS; seg++)
		segment[seg].Clear();

return;
}


extern "C" void gacwk (long* wkid)
//    ==========================
//
//    activate workstation
//	long *wkid; // workstation id
//
{


//  set device params


wind[0] = 0.0;
wind[1] = 1.0;
wind[2] = 0.0;
wind[3] = 1.0;
workstationWindow[0] = 0.0;
workstationWindow[1] = 1.0;
workstationWindow[2] = 0.0;
workstationWindow[3] = 1.0;

return;
}


extern "C" void gdawk (long* wkid)
//    ==========================
//
//    deactivate workstation
//		long *wkid;

{

      return;
}


extern "C" void gclrwk (long* wkid, long* cofl)
//    ==========================
//
//    clear workstation
//	long *wkid;   // workstation ident
//	long *cofl;   // control flag, 0=conditional, 1=always

{
	int	seg;

	for (seg=0; seg<NUM_SEGS; seg++)
		segment[seg].Clear();

	wantAspect = TRUE;	// recalculate after clear

	return;
}


extern "C" void guwk (long* wkid,long* regfl)
//    ==========================
//
//    update workstation
//	long *wkid; // workstation ident
//	long *regfl; // control flag, 0=perform, ress, 1=perform

{

	//theDoc->UpdateAllViews(NULL);	// send a paint message to redraw everything
	theView->Invalidate();

return;
}



//
// $$$$$$$$$$$$$$$$$$$output primitives$$$$$$$$$$$$$$$$$$$
//
extern "C" long gpl (long* n, float* px, float* py)
//    ==========================
//
//    polyline

//long *n;         // number of points
//float px[100],py[100];  // points in world coords

{


	CgksLine*	pLine;
	long		handle;

	pLine = new CgksLine (px, py, *n, lineType, lineWidth, lineColourIndex);
	handle = segment[nowSegment].Add(pLine);
	return (handle);
}


extern "C" long gpm (long* n, float* px, float* py)
//    ==========================
//
//    polymarker (only type 1 used = dot)
//   now a plus for super vga
//long *n;             // number of points (small!!!)
//float px[100],py[100];  // points in world coords

{

	CgksMarker*	pMarker;
	int			length;
	long		handle;

	pMarker = new CgksMarker (px, py, *n, markerType,
				markerSize, markerColourIndex);
	handle = segment[nowSegment].Add(pMarker);
	return (handle);
}


extern "C" long gtx (float* px, float* py, char* pString)
//    ================================
//
//    text

//float *px,*py;     // text posn in world coords
//char  *pString;    // string of characters
//long  *num;       //  length NEW for windows
{

		
	CgksText*	pText;
	int			length;
	long		handle;
	int			start=0;

	while (pString[start] == ' ') // remove leading blanks
		start++;

	pText = new CgksText (*px, *py, &pString[start],
				worldCharHt, charExpansion, textAlignHoriz, textAlignVert, textPath,
				currentFont, textColourIndex);
	handle = segment[nowSegment].Add(pText);
	return (handle);
}

extern "C" void gfatrn (short* num,float* px, float* py, short* ix, short* iy)
//    ==========================

//    transform array for poly fill

//short *num;             // number of points
//float px[100],py[100];  // points in world coords
//short ix[100],iy[100];  // output device coords
{
int i,n;
	long val;

	n = *num;
	for (i=0; i<n; i++)
    {
	 xw2dev (px[i],&val);
		ix[i] = val;
		yw2dev (py[i],&val);
		iy[i] = noYpix - val;
    }

	return;
}

extern "C" long gfa (long* num, float* px, float* py, long* bnd)
//    ==========================

//    fill area 

//long *num;        // number of points
//float px[100],py[100];  // points in world coords
//long *bnd;      // if boundaries reqd, 0=>no
{


	CgksPolygon*	pPolygon;
	long		handle;
	BOOL		doBoundary;

	doBoundary = *bnd;

	pPolygon = new CgksPolygon (px, py, *num, polyInteriorStyle, polyColourIndex, lineColourIndex, doBoundary);
	handle = segment[nowSegment].Add(pPolygon);
	return (handle);
}

extern "C" long  gfrect (float* x1, float* x2, float* y1, float* y2)
//    ==============================

//    fill rectangle - handle as POLYGON

//float *x1,*x2,*y1,*y2; // corners in world coords

{
	long	handle;
	float	x[5], y[5];
	long	num;
	long	bnd;

	num = 5;
	bnd = FALSE;
	x[0] = *x1;
	y[0] = *y1;
	x[1] = *x1;
	y[1] = *y2;
	x[2] = *x2;
	y[2] = *y2;
	x[3] = *x2;
	y[3] = *y1;
	x[4] = *x1;
	y[4] = *y1;

	handle = gfa (&num, x, y, &bnd);

	return (handle);
}


extern "C" void wsetpix (short* ix, short* iy, short* index)
//    ==========================

//    set pixel value for images, starting top left

//short *ix;        // integer*2 X
//short *iy;        // integer*2 Y
//short *index;     // LUT index

{
	CPaintDC dc(gksWND);

	dc.SetPixel (*ix,*iy,PALETTEINDEX(*index));
	return;
}



extern "C" void wgetpix (short* ix, short* iy, short* index)
//    ==========================

//    get pixel value starting at top left

//short *ix;        // integer*2 X
//short *iy;        // integer*2 Y
//short *index;     // LUT index

{
	CPaintDC dc(gksWND);
	COLORREF colref;
	colref = dc.GetPixel (*ix,*iy);
//	*index = gksPalette.GetNearestPaletteIndex(colref);
	*index = 0; //?????????
	return;
}

// %%%%%%%%%%%%% update primitives

extern "C" void gupdpl (long* handle, long* type, long* width, long* colIndex)
//    ==========================
//
//    update polyline


{
	CgksLine*	pLine;

	pLine = (CgksLine*)segment[nowSegment].Find(*handle, gksLine);
	if (!pLine)
		GKSfatalError("Invalid line handle");
	pLine->Attributes(*type, *width, *colIndex);
}


extern "C" void gupdpm (long* handle, float* size, long* colIndex)
//    ============================================================
//
//    update polymarker 

{

	CgksMarker*	pMarker;
	pMarker = (CgksMarker*)segment[nowSegment].Find(*handle, gksMarker);
	if (!pMarker)
		GKSfatalError("Invalid marker handle");
	pMarker->Attributes(*size, *colIndex);
}

extern "C" void gupdfa (long* handle, long* colIndex)
//    ==================================================

//    update fill area 
{


	CgksPolygon*	pPolygon;
	pPolygon = (CgksPolygon*)segment[nowSegment].Find(*handle, gksPolygon);
	if (!pPolygon)
		GKSfatalError("Invalid polygon handle");
	pPolygon->Attributes(*colIndex);
}

//&&&&&&&&&& find primitive attributes

extern "C" void gfacol (short* index)
//    ====================================

//    return poly fill colour index

//short  *index;

{
	*index = polyColourIndex;
	return;
}


extern "C" void gplcol (short* index)
//    ====================================

//    return polyline colour index

//short  *index;

{
	*index = lineColourIndex;
	return;
}

/*-----------------------------
extern "C" void GFACLP (minx,maxx,miny,maxy)
//    ====================================

//    return clipping rectangle

short  *minx;
short  *maxx;
short  *miny;
short  *maxy;
{
*minx = minpxx;
*miny = minpxy;
*maxx = maxpxx;
*maxy = maxpxy;
return;
}
--------------------------------------*/

// $$$$$$$$$$$$$$$$$$$output primitives$$$$$$$$$$$$$$$$$$$

extern "C" void gsseg (long* seg)
//    ==========================

//    set current segment

{
	nowSegment = *seg;
	if (nowSegment < 1 || nowSegment > NUM_SEGS)
		GKSfatalError ("Illegal segment number");

	return;
}


extern "C" void gsln (long* ltype)
//    ==========================

//    set line-type range 1 to 5 (1 = solid)
//	  maps to PS_SOLID=0, etc

//long *ltype; // linetype

{

	lineType = *ltype - 1;
	if (lineType < 0 || lineType > 4)
		lineType = 0;
	return;
}


extern "C" void gslw (long* width)
//    ==========================

//    set polyline width

//long *width;  // width 1,2,3,4
{

	lineWidth = *width;
	return;
}


extern "C" void gsplci (long* coli)
//    ==========================

//    set polyline colour index

//long *coli;  // colour index

{

	lineColourIndex = *coli;
	return;
}


extern "C" void gsmk (long* mtype)
//    ==========================

//    set marker type

//long *mtype; // marker type

{

	markerType = *mtype;
	return;
}

extern "C" void gsmksize (float* msize)
//    ==========================

//    set marker type

//long *mtype; // marker type

{

	markerSize = *msize;
	return;
}


extern "C" void gspmci (long* coli)
//    ==========================

//    set polymarker colour index

//long *coli; // colour index

{

	markerColourIndex = *coli;
	return;
}

extern "C" void winfnt (char* font_name, long* id)
//    ==========================

//    give font name

//char *font_name;
//long *id;

{
	currentFont = *id;
	if (currentFont < 1 || currentFont > NUM_FONTS)
		GKSfatalError("Font ID invalid");

	strcpy (fontFace[currentFont-1],font_name);
	return;
}


extern "C" void mrkfnt (char* font_name)
//    ==========================

//    give font name for markers

//char *font_name;
//long *id;

{

	strcpy (fontFace[NUM_FONTS], font_name);
	return;
}


extern "C" void gstxfp (long* font, long* prec)
//    ==========================

//    set font and precision

//long *font; // text font (ident no)
//long *prec; // precision, 0=string, 1=char, 2=stroke

{
	currentFont = *font;
	if (currentFont<1 || currentFont>NUM_FONTS)
		GKSfatalError ("Illegal font number");
	fontPtrecision = *prec;

	return;
}



extern "C" void gschh (float* chh)
//    ==========================

//    set character height

//float *chh; // height in world coords

{

	worldCharHt = *chh;
	return;
}


extern "C" void gschxp (float* chxp)
//    ==========================

//    set character expansion factor

//float *chxp; // expansion factor x to y

{

	charExpansion = *chxp;  

	return;
}


extern "C" void gstxci (long* coli)
//    ==========================

//    set text colour index

//long *coli; // colour index

{
	textColourIndex = *coli;
	return;
}


extern "C" void gstxp (long* txp) 
//    ==========================

//    set text path

//long *txp; // path, 0=right, 3=down

{
	textPath = *txp;
	return;
}


extern "C" void gstxal (long* txalh, long* txalv)
//    ==========================

//    set text alignment

//long *txalh; // horizontal, 1=left, 2=centre, 3=right
//long *txalv; // vertical, 1=top, 4=base

{
	textAlignHoriz = *txalh;
	textAlignVert  = *txalv;
	return;
}


extern "C" void gsfais (long* ints)
//    ==========================

//    set fill area interior style

//long *ints; // style, 1=solid,2=diagonal hatch at 45, 3=horiz/vert hatch,
//						4=cross hatch at 45, 5=diagonal hatch at 135 , 6=horizontal hatch
//						7=vertical hatch

{
	polyInteriorStyle = *ints;
	return;
}



extern "C" void gsfaci (long* coli)
//    ==========================

//    set fill area colour index

//long *coli; // colour index

{

	polyColourIndex = *coli;
	return;
}


extern "C" void OLDgsasf (long* lasf)
//    =======================

//    set aspect source flags

//long *lasf; // flags, all individual=1 for colourmap


{
	return;
}



// $$$$$$$$$$$$$$$$$$$ workstation attributes $$$$$$$$$$$$$$$$$$$

extern "C" void gscr (long* wkid, long* ci, float* cr, float* cg, float* cb)
//    ==========================

//    set colour representation

//long *wkid;
//long *ci; // colour index, 0,1,....
//float *cr; // red value
//float *cg; // green, (0.0-1.0)
//float *cb; // blue

{
	int lut;
	lut = *ci;
	set_lut (lut,*cr,*cg,*cb);
//	if (lut == 0)
//	  dc.SetBkColor(GKScolour(lut));

return;
}



extern "C" void gslut (long* wkid, float* cr, float* cg, float* cb)
//    ==========================

//    set whole look-up table

//long *wkid;
//float *cr; // red array
//float *cg; // green, (0.0-1.0) array
//float *cb; // blue array

{
int i;

for (i = 0; i < PALSIZE; i++)
   set_lut (i,cr[i],cg[i],cb[i]);

//dc.SetBkColor(GKScolour(0));

return;
}



// $$$$$$$$$$$$$$$$$$$ transformation functions $$$$$$$$$$$$$$$$$$$

extern "C" void gswn (long* tnr, float* xmin, float* xmax, float* ymin, float* ymax)
//    ==========================

//    set window

//long *tnr; // transformation number
//float *xmin;
//float *xmax;
//float *ymin; // window in world coords
//float *ymax;

{
	CgksWindow*	pWindow;
	userWindow[0] = *xmin;
	userWindow[1] = *xmax;
	userWindow[2] = *ymin; // store values
	userWindow[3] = *ymax;

	pWindow = new CgksWindow (*xmin, *xmax, *ymin, *ymax);
	segment[nowSegment].Add(pWindow);

	SetWindVP();	// keep current for text size calculation

	return;
}


extern "C" void gsvp (long* tnr, float* xmin, float* xmax, float* ymin, float* ymax)
//    ==========================

//    set viewport

//long  *tnr;  // transformation number
//float *xmin;
//float *xmax;
//float *ymin; // viewport in normalised device coords
//float *ymax;
{
	CgksViewport*	pViewport;

	userViewport[0] = *xmin;
	userViewport[1] = *xmax;
	userViewport[2] = *ymin; // store values
	userViewport[3] = *ymax;
	pViewport = new CgksViewport (*xmin, *xmax, *ymin, *ymax);
	segment[nowSegment].Add(pViewport);
	SetWindVP();	// keep current for text size calculation

	return;
}


extern "C" void OLDgsvpip (long* tnr, long* rtnr, long* relpri)
//    ==========================

//    set viewport input priority

//long *tnr; // transformation number
//long *rtnr; // reference trans. number
//long *relpri; // relative priority; 0=higher, 1=lower

{

      return;
}


extern "C" void OLDgselnt (long* tnr)
//    ==========================

//    set transformation no

//long *tnr; // transformation number

{

      return;
}


extern "C" void gsclip (long* clsw)
//    ==========================

//    set clipping indicator

//long *clsw;   // indicator, 0=none, 1=clip

{

	clippingFlag = *clsw;

	segment[nowSegment].SetClip(clippingFlag);	// store in segment

	return;
}



extern "C" void gclrseg ()
//    ==========================

//    clear current segment


{


	segment[nowSegment].Clear();

	return;
}


extern "C" void gspick (long* flag)
//    ==========================

//    set pickable indicator for current segment

//long *flag;   // indicator, 0=none, 1=pickable

{

	pickableFlag = *flag;

	segment[nowSegment].SetPickable(pickableFlag);	// store in segment

	return;
}



// $$$$$$$$$$$$$$$$$$$$$$$$$$ inquiry functions $$$$$$$$$$$$$$$$$$$$$$$$$$


extern "C" void gdefn (long* nnox, long* nnoy, long* nnlut)
//    ===============================================
//
//    return screen params - no DOS equivalent

//long *nnox;   // no pixels across screen 
//long *nnoy;   // no lines down screen 
//long *nnlut;  // length lut
//
{

	*nnox  = noXpix;
	*nnoy  = noYpix;
	*nnlut = PALSIZE;
	return;
}

extern "C" void XXXgqpx (long* wkid, float* px, float* py, long* errind, long*coli)
//    ==========================

//    inquire pixel

//long *wkid; // workstation ident
//float *px,*py; // point in world coords
//long *errind; // error indicator, 0=ok
//long *coli; // colour index, returned

{
	CPaintDC dc(gksWND);
	long x,y;

	xw2dev (*px, &x);
	yw2dev (*py, &y);

	*coli = dc.GetPixel (x,y);

	return;
}


// $$$$$$$$$$$$$$$$$$$ input / cursor functions $$$$$$$$$$$$$$$$$$$

extern "C" void ginlc (long* wkid, long* type, float* initial, long* handle)
//    ==========================

//    initialise locator. Results return in callback routine.

//long  *wkid;      // workstation ident
//long  *type;      // type of locator
//	0 = none, disable
//	1 = cross hair (point)
//	2 = box cursor (select both corners)
//	3 = circle type, select centre & outside point
//	4 = straight line (select both ends)
//	5 = fixed size box
//	6 = digitise line
//float *initial;  // initial data where required
//	fixed size box - size of box in world coords X then Y size

// note that the window / viewport of the current segment is applied, so the
// segment MUST be chosen before the call.

{
	InitLocator(*type, initial, *handle, TRUE);

	return;
}


// following are cursor requests that wait for results ONCE
// global data is in cursor routines



// wait loop for locator

static void LocatorWait()
{
	MSG msg;
	//HWND hWnd;
	POINT point;

	//hWnd = gksWND->m_hWnd;

	while (!gotCursor)
	{
		WaitMessage();
		if (GetMessage(&msg, NULL, 0, 0) == TRUE)
		{
			if (msg.message == WM_LBUTTONDOWN)
			{
				point.x = LOWORD(msg.lParam);
				point.y = HIWORD(msg.lParam);
				GKSonLButtonDown(point);
			}
			if (msg.message == WM_LBUTTONUP)
			{
				point.x = LOWORD(msg.lParam);
				point.y = HIWORD(msg.lParam);
				GKSonLButtonUp(point);
			}
			if (msg.message == WM_MOUSEMOVE)
			{
				point.x = LOWORD(msg.lParam);
				point.y = HIWORD(msg.lParam);
				GKSonMouseMove(point);
			}
		}
	}
}



extern "C" void  grqlc  (long* wkid, float* px, float* py)
//    ==========================

//    request locator

{
	InitLocator(1, NULL, 0, FALSE);
	LocatorWait();
	*px = xCursor[0];
	*py = yCursor[0];
	return;
}


extern "C" void  grqbox (long* wkid, float* px1, float* py1, float* px2, float* py2)
//    ======================================================

//    request locator - box type, select both corners

{


	InitLocator(2, NULL, 0, FALSE);
	LocatorWait();
	*px1 = xCursor[0];
	*py1 = yCursor[0];
	*px2 = xCursor[1];
	*py2 = yCursor[1];
	return;
}


extern "C" void  grqcirc (long* wkid, float* px, float* py, float* radius)
//    ======================================================

//    request locator - circle type, select centre & outside point

{


	InitLocator(3, NULL, 0, FALSE);
	LocatorWait();
	*px = xCursor[0];
	*py = yCursor[0];
	*radius = radiusCursor;
	return;
}


extern "C" void  grqlin (long* wkid, float* px1, float* py1, float* px2, float* py2)
//    ======================================================

//    request locator - line, select both ends

{

	InitLocator(4, NULL, 0, FALSE);
	LocatorWait();
	*px1 = xCursor[0];
	*py1 = yCursor[0];
	*px2 = xCursor[1];
	*py2 = yCursor[1];
	return;
}


extern "C" void  grqfb (long* wkid, float* px1, float* py1, float* px2, float* py2)
//    ======================================================
 
//    request locator - fixed size box

{

	float initial[2];
	initial[0] = *px2 - *px1;  // box size
	if (initial[0] < 0.0)
		initial[0] = -initial[0];
	initial[1] = *py2 - *py1;  // box size
	if (initial[1] < 0.0)
		initial[1] = -initial[1];
	InitLocator(5, initial, 0, FALSE);
	LocatorWait();
	*px1 = xCursor[0];
	*py1 = yCursor[0];
	*px2 = xCursor[1];
	*py2 = yCursor[1];
	return;
}


extern "C" void  grqdig (long* wkid, float* px, float* py, int* sizearray, int* numdig)
//    ======================================================

//    request locator - digitise a line

{

	int num;
	InitLocator(6, NULL, 0, FALSE);
	LocatorWait();
	num = numCursor;
	if (num > *sizearray)
		num = *sizearray;
	for (int i=0; i<num; i++)
	{
		px[i] = xCursor[i];
		py[i] = yCursor[i];
	}
	*numdig = num;
	return;
}

