//
//
//                              S I M   G I N E
//
//             __               ___   ______,-------
//           __==__,------------/|\--|      | .-.-.|    ___________
//         (|     |--------------|---|------| '-`-`|  _/___________\_
//         (|_____|      _       _   |   _  | 6000 | |               |
//          |__\\_|`-._/___\___/___\_|_/___\|      | |               |
//         __/ |===|--|_____|_|_____|_|___  |\_____|=|_______________|
//      |=|[_]==[_]    \ _ /   \ _ /   \ _ /          [_]   [_]   [_]
//
//
//                     A Simluator Framework for MythOS(tm)
//
//                     Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1997-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Dan Higdon and Chuck Walbourn
//
// simtext.cpp
//
// This module contains the gutenberg text output class.
//
//

//
//
//                                Includes
//
//

#include "simgine.hpp"

//
//
//                                 Code
//
//

//
//  Operations  
//

//
// SimText - outr
//
void SimText::outr(ulong id)
{
    char    buff[1024];

    assertMyth("SimText::outr needs SimApp w/ instance",
               SimApp != 0 && SimApp->hInstance);

    LoadString(SimApp->hInstance, id, buff, sizeof(buff));

    GBergText::out(buff);
}

void SimText::outr(long x, long y, ulong id)
{
    char    buff[1024];

    assertMyth("SimText::outr needs SimApp w/ instance",
               SimApp != 0 && SimApp->hInstance);

    LoadString(SimApp->hInstance, id, buff, sizeof(buff));

    GBergText::out(x, y, buff);
}


//
// SimText - outrf
//
void SimText::outrf(ulong id, ...)
{
    char fmt[512];
    char buff[1024];

    assertMyth("SimText::outr needs SimApp w/ instance",
               SimApp != 0 && SimApp->hInstance);

    if (LoadString(SimApp->hInstance, id, fmt, sizeof(fmt)))
    {
        // Perform a printf
        va_list parms;
        va_start (parms, id);
        int len = wvsprintf (buff, fmt, parms);
        va_end (parms);

        assert (len <= sizeof (buff));

        GBergText::out (buff);
    }
}

// End of module - simtext.cpp 

