//
//
//
//
//
//
//
//
//
//
// Microsoft Windows 95/98/NT Version 
//
//Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Tim Little & Chuck Walbourn
//
// esprtgeo.cpp
//
// Contains the code for the EschParticleGeometry class which is a
// particle that uses an EschGeometry as the drawable.
//
//

//
//
//                                Includes
//
//

#include "escher.hpp"

//
//
//                                 Code
//
//

//
//  Constructors/Destructors  
//

//Ŀ
// EschParticleGeometry - Constructor                                       
//                                                                          
// Initializes the particle.                                                
//
EschParticleGeometry::EschParticleGeometry(EschGeometry *g, float l) :
    EschParticle(),
    geom(g),
    rotate_i(0),
    rotate_j(0),
    rotate_k(0)
{
    dtyp = ESCH_DRWT_PRTGEOMETRY;

    assertMyth("EschParticleGeometry needs a valid geometry pointer",
               g != 0);
    g->get_position(&pos);
    life = l;
    velocity.i = 0;  velocity.j = 0;  velocity.k = 0;
    acceleration.i = 0;  acceleration.j = 0;  acceleration.k = 0;
}

EschParticleGeometry::EschParticleGeometry(EschGeometry *g,
                                           float ii, float ij, float ik,
                                           float l) :
    EschParticle(),
    geom(g),
    rotate_i(0),
    rotate_j(0),
    rotate_k(0)
{
    dtyp = ESCH_DRWT_PRTGEOMETRY;

    assertMyth("EschParticleGeometry needs a valid geometry pointer",
               g != 0);
    g->get_position(&pos);
    life = l;
    velocity.i = ii;  velocity.j = ij;  velocity.k = ik;
    acceleration.i = 0;  acceleration.j = 0;  acceleration.k = 0;
}

EschParticleGeometry::EschParticleGeometry(EschGeometry *g,
                                           const EschVector *v,
                                           float l) :
    EschParticle(),
    geom(g),
    rotate_i(0),
    rotate_j(0),
    rotate_k(0)
{
    dtyp = ESCH_DRWT_PRTGEOMETRY;

    assertMyth("EschParticleGeometry needs a valid geometry pointer",
               g != 0);
    g->get_position(&pos);
    life = l;
    velocity = *v;
    acceleration.i = 0;  acceleration.j = 0;  acceleration.k = 0;
}


//Ŀ
// EschParticleGeometry - Destructor                                        
//
EschParticleGeometry::~EschParticleGeometry()
{
    release();
}



//
//  Operations  
//

//Ŀ
// EschParticleGeometry - operator =                                        
//                                                                          
// Copies the data from another particle geometry                           
//
const EschParticleGeometry &EschParticleGeometry::operator =
                                              (const EschParticleGeometry &pg)
{
    if (this != &pg)
    {
        release();

        EschParticle::operator = (pg);

        geom = pg.geom;
        rotate_i = pg.rotate_i;
        rotate_j = pg.rotate_j;
        rotate_k = pg.rotate_k;
    }
    return *this;
}


//Ŀ
// EschParticleGeometry - draw                                              
//                                                                          
// Draws the given particle using the current drawing context at the        
// current position.                                                        
//
void EschParticleGeometry::draw()
{
    if (geom)
    {
        geom->flags &= ~ESCH_DRW_VISIBLE;
        geom->draw();

        // Do CULL option...
        if (!(geom->flags & ESCH_DRW_VISIBLE))
        {
            if ((flags & ESCH_PRT_CULLIFOUTOFVIEW)
                && (flags & ESCH_PRT_WASVISIBLE))
            {
                life = 0;
                flags |= ESCH_DRW_SKIP;
            }
        }
        else
            flags |= ESCH_PRT_WASVISIBLE;
    }
}


//Ŀ
// EschParticleGeometry - animate                                           
//                                                                          
// Performs any operations needed to move the particle to the next frame,   
// including life tests for death of the particle.                          
//
void EschParticleGeometry::animate()
{
    EschParticle::animate();

    if (!geom)
        return;

    if (interval == 0)
        return;

    if (rotate_i != 0)
        geom->pitch(rotate_i * interval,0);

    if (rotate_j != 0)
        geom->yaw(rotate_j * interval,0);

    if (rotate_k != 0)
        geom->roll(rotate_k * interval,0);

    geom->set_position(pos.x, pos.y, pos.z);

    if (!(geom->flags & ESCH_DRW_SKIPANIMATE))
        geom->animate();
}


//Ŀ
// EschParticleGeometry - release                                           
//
void EschParticleGeometry::release()
{
    if (geom)
    {
        delete geom;
        geom=0;
    }
}



//
//  Utility Routines  
//

//Ŀ
// EschParticleGeometry - set_position                                      
//
void EschParticleGeometry::set_position(float ix, float iy, float iz)
{
    pos.x = ix;
    pos.y = iy;
    pos.z = iz;

    if (geom)
        geom->set_position(ix, iy, iz);
}


//Ŀ
// EschParticleGeometry - reset                                             
//
void EschParticleGeometry::reset()
{
    if (!geom)
        return;

    geom->reset();
    geom->set_position(&pos);
}

// End of module - esprtgeo.cpp 

