{ OPTTST.PAS : Test OPTLIB unit

  Title   : OPTTST
  Version : 2.0
  Date    : Nov 11,1996
  Author  : J R Ferguson
  Language: Borland Turbo Pascal 4.0 through 7.0
            DOS real and protected mode
  Usage   : Program
}

PROGRAM OPTTST;
uses OptLib, ArgLib, DefLib, RngLib;

var
  OptLst : OptLstPtr;

procedure WriteRg(r: RngTyp);
begin if r<>nil then with r^ do begin
  write(l,'..',h);
  if nxt<>nil then begin write(', '); WriteRg(nxt) end;
end end;

procedure Help;
  procedure wl(s:StpTyp); begin writeln(s) end;
begin
wl('usage: OPTTST [/option[..] [..]]');
wl('option           type         initial  default  minimum   maximum');
wl('---------------  -----------  -------  -------  --------  --------------');
wl('S[+/-]           switch       FALSE    TRUE');
wl('N[n]             number       80       80       0         255');
wl('Mn1[,[n2]]       number list  1,2      ,2       -99,-99   +99,+99');
wl('O[n1],n2[,[n3]]  number list  1,2,3    1,,3     0,0,0     9999,9999,9999');
wl('R[n1][,[n2]]     range        empty    1,1      1,1       80,80');
wl('C[c]             character    ''-''      ''-''');
wl('T[text]          string       ''''       ''''');
wl('');
end;

procedure MainInit;
var i: ArgInd; ok: boolean; AllOk: boolean;
begin
  OptInit(OptLst);
  OptDefSw(OptLst,'S');
  OptDefNm(OptLst,'N',false,    0, 255,80);
  OptDefNm(OptLst,'M',true ,  -99, +99, 1);
  OptDefNm(OptLst,'M',false,  -99, +99, 2);
  OptDefNm(OptLst,'O',false,    0,9999, 1);
  OptDefNm(OptLst,'O',true ,    0,9999, 2);
  OptDefNm(OptLst,'O',false,    0,9999, 3);
  OptDefRg(OptLst,'R',false,    1,  80, 1,
                      false,    1,  80, 1);
  OptDefCh(OptLst,'C', '-');
  OptDefSt(OptLst,'T');
  GetArgs; AllOk:= true;
  for i:= 1 to ArgC do begin
    if OptParse(OptLst,ArgV[i],ok) then begin
      if ok then begin
         writeln('option ok     Argument ',i:3,': "',ArgV[i],'"');
      end
      else begin
         AllOk:= false;
         writeln('option error  Argument ',i:3,': "',ArgV[i],'"');
      end;
    end
    else writeln('no option     Argument ',i:3,': "',ArgV[i],'"');
  end;
  if not AllOk then Help;
end;


procedure MainExit;
begin
  OptDone(OptLst);
end;


begin { Main program }
  writeln('OPTTST : Test op OPTLIB');
  MainInit;
  writeln('Current options:');
  writeln('  Switch S: scanned = ',OptScanned(OptLst,'S'):5,
                      ', value = ',OptValSw(OptLst,'S'));
  writeln('  Number N: scanned = ',OptScanned(OptLst,'N'):5,
                      ', value = ',OptValNm(OptLst,'N',1));
  writeln('  NumLst M: scanned = ',OptScanned(OptLst,'M'):5,
                      ', value = ',OptValNm(OptLst,'M',1),',',
                                   OptValNm(OptLst,'M',2));
  writeln('  NumLst O: scanned = ',OptScanned(OptLst,'O'):5,
                      ', value = ',OptValNm(OptLst,'O',1),',',
                                   OptValNm(OptLst,'O',2),',',
                                   OptValNm(OptLst,'O',3));
  write  ('  Range  R: scanned = ',OptScanned(OptLst,'R'):5,
                      ', value = '); WriteRg(OptValRg(OptLst,'R')); writeln;
  writeln('  Char   C: scanned = ',OptScanned(OptLst,'C'):5,
                      ', value = ''',OptValCh(OptLst,'C'),'''');
  writeln('  Text   T: scanned = ',OptScanned(OptLst,'T'):5,
                      ', value = ''',OptValSt(OptLst,'T'),'''');
  MainExit;
end.
