{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Strings/Chained3.pas             [x] Protected mode

  Chanined tString instances. This is an example that demonstrates
  the built-in chain technique in tString. tStrings are more than
  simple text strings - they are prepared to handle an entire
  text structure!

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFSTREAM, EFSTRING, EFTEST;


var A, B, Delimeters : pToken;

begin
     MemPush; { EFTEST }

     { Create a common string }

     New (A, Initialize ('WRITING EQUALLY DISTANT PHRASES.'));

     B := A;
     A^.Split (Delimeters, 8); { Split to 7 character segments }

     WriteLn ('Split into 7 character blocks:');

     while Assigned (A) do begin
           if A^.IsEqual (Endl) then Write ('<Endl>')
              else A^.StreamWrite (StdIO);

           A := pToken(A^.Successor);
           if Assigned (A) then Write ('|');
     end;
     WriteLn;

     WriteLn;
     WriteLn ('And merged into one entity again:');

     B^.Merge;
     B^.StreamWrite (StdIO);

     WriteLn;
     B^.Free;

     MemPop; { EFTEST }
end.