{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Misc/Timer.pas                   [x] Protected mode

  This program demonstrates how you can use the timer object for
  high-precision timing.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFBASIC, CRT;


var Timer   : tTimer;
    Elapsed : real;

begin
     WriteLn ('* High-precision timer and Pascal delay comparison *');

     Timer.Initialize;

     { CRT delay }
     Timer.Reset;
     Delay (2000);
     Elapsed := Timer.ElapsedMS;
     WriteLn ('Borland Pascal delay took ', Elapsed:0:6, ' [ms] for a 2000 millesecond-delay');

     { EFLIB delay }
     Timer.Reset;
     Timer.Delay (2000);
     Elapsed := Timer.ElapsedMS;
     WriteLn ('EFLIB delay actually took ', Elapsed:0:6, ' [ms]');

     Timer.Intercept;
end.