{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Math/Vector.pas                  [x] Protected mode

  This is an example on vector arithmetics.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFSTREAM, EFMATH;


var U, V : tVector;

begin
     { This example demonstrates the vector arithmetics that
       is built in the EFMATH unit in EFLIB. All the common
       vector operations are available. Like other math objects
       in EFLIB, vectors share the polymorphic type-cast friendly
       interface that automatically switches between the right
       operations for your objects. Use the same multiplication
       method when multiplying with scalars as you do when you
       multiply with other vectors (cross product). }

     U.Initialize (3, 4, -5);
     V.Initialize (3, -4, -5);

     WriteLn ('* Vector arithmetics *');

     WriteLn ( '(a) Length : ', '|U| = ', U.Magnitude:0:2,
                               ' |V| = ', V.Magnitude:0:2 );

     WriteLn ( '(b) Angle between U and V : ', U.Angle (@V):0:2,
               ' radians within [-Pi/2, Pi/2].' );

     WriteLn ( '(c) Scalar projection of U in the direction ',
               'of V : ', U.Projection (@V):0:2 );

     WriteLn ( '(d) Dot product U * V = ', U.DotProduct (@V):0:2 );

     U.Multiply (@V); { Automatic type-casting }
     Write ( '(e) Vector product U x V = ');
     U.StreamWrite (StdIO); WriteLn ('.'); { Write to standard output }

     U.Normalize; { Normalize the V vector }
     WriteLn ( '(f) Normalized vector V = (', V.X:0:1, ', ',
               V.Y:0:1, ', ', V.Z:0:1, ').' ); { Write using selectors }

     U.Intercept; V.Intercept;

end.