{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Stacks/Simple.pas       [x] Protected mode

  This is a simple example that shows how the stack ADT works.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFDATA, EFTEST;


const NumberOfElements = 100;

var Index, Number : integer;
    MyStack       : tStack;

begin
     WriteLn ('* Stack demonstration');

     MemPush; { EFTEST }

     with MyStack do begin

          Initialize (SizeOf(Integer));
                      { Element size }

          { Stack operations:

            Push (Data) - add an element to the stack.
            Pop (Data) - retrieve and erase the last inserted element.
            Top (Data) - retrieve the last inserted element.
            Skip (Data) - erase the last inserted element. }

          { Push (add) some numbers ... }
          for Index := NumberOfElements downto 1 do Push (Index);

          { Pop (retrieve) numbers ... }

          while not IsEmpty do begin
                Pop (Number);
                Write (Number:5);
          end;

          WriteLn;

          Intercept;
     end;

     MemPop; { EFTEST }
end.
