{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Lists/List3.pas         [x] Protected mode

  Example of the doubly linked list ADT. This example demonstrates
  searching in lists (the same feature exist in all linear ADT's).

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFLIST, EFELEM, EFTEST, EFSTRING;


var List      : tList;
    Element   : pElement;
    Data      : string[40];
    Index     : word;
    Memory    : longint;

begin
     Memory := MemAvail;

     with List do begin

          Initialize ( SizeOf(Data) );

          Randomize;

          { Generate a structure containing randomly generated data }
          for Index := 1 to 2000 do begin
              with CreateRandomString (Pred(SizeOf(Data)))^ do begin
                   Data := Pascal;
                   Free;
              end;
              Store (Data);
          end;

          { We now know that Data (the last inserted variable)
            is in the list, and that it is the last element (tList
            inserts element at the end of the list). Let us check
            this! }

          WriteLn ('The last inserted element has index ', Search (Data), '.');
          WriteLn ('But that is the same as the last element (', Elements, ').');

          { We can also search for elements inside the list, that is,
            search for tElement instances instead of raw data. All
            elements are internally stored as tElement instances,
            packaged in tLinkage containers with link capabilities.
            Now, let us us Locate to find an element that we ask
            the ADT to create (CreateIterator component selector method). }

          Element := CreateElement; { Create a tGenericElement }
          Element^.Update (Data, SizeOf(Data)); { Update it }
          WriteLn ('Once again, element no. ', Locate (Element), ' was found.');
          Element^.Free; { Intercept our external element }

          { Let us search for some non-existing data! }
          Data := 'NON-EXISTING SURELY';
          if Search (Data) = 0
             then WriteLn ('We searched for some data, but it is not inside the list.')
             else WriteLn ('This is certainly very rare.');

          if IsIntact
             then WriteLn ('Link integrity OK.');

          Intercept;
     end;

     if Memory <> MemAvail then WriteLn ('Error in structure disposal.');
     WriteLn  ('Testing completed.');
end.