{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Lists/List1.pas         [x] Protected mode

  Example of the doubly linked list ADT.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFBASIC, EFSTRING, EFLIST, EFTEST;


var MyList : pList;
    Data : string; Index : word;

begin
     { Create a new list instance. }
     MyList := New ( pList, Initialize ( SizeOf(Data) ) );
                                         { Element size (in bytes) }

     with MyList^ do begin

          Randomize;

          { Place some elements in the list }

          for Index := 1 to 10 do begin
              Str (Index, Data);
              Store (Data);
          end;


          { Use a list iterator (tNodeIterator) to
            traverse through the list. }

          with CreateIterator^ do begin

               while not IsEnd do begin { Condition; not end of list }

                     { Element contents = the string }
                     WriteLn (String(Content^));

                     WalkForward; { Next element }

               end;

               Free;

          end;

          Free;
     end;
end.