{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Elements/Generic3.pas   [x] Protected mode

  Polymorphic elements. This is a demonstration of how tGenericElement
  allows you to place any data inside an element, and of tADT's support
  of tElement instances.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFADT, EFLIST, EFELEM;


const SomeContent : string
        = 'Revolution in programming';

var MyADT : pLinearADT;
    MyElement : pElement;

begin
     MyADT := New (pList, Initialize (SizeOf(SomeContent)));

     with MyADT^ do begin

          MyElement := CreateElement; { = tGenericElement }
          MyElement^.Allocate (SizeOf(SomeContent));
          MyElement^.CopyIn ( @SomeContent [0], SizeOf (SomeContent), 0);

          { Introduction: all ADT's instantiate tElement instances
            for their elements. When you are addressing an element
            inside an ADT, you normally don't bother about how that
            element is stored, but you should know a little about the
            internal technique.

            The ADT descide how it stores data. The decision is
            made in the CreateElement method (a "component selector").
            By overriding this method, you can force an ADT to use
            other element types. The normal type, used by all ADT's
            by default, is tGenericElement. }

          Put (MyElement); { Put into ADT }
          Store (MyElement^.Data(0)^); { Copy into ADT: new element! }

          { Notice the difference between Put and Store. Put requires
            that you create the element instance, while Store takes
            care of the whole thing, finally letting CreateElement
            make the descision. Hence you can bypass CreateElement
            by using Put. Also, Store "copies" the contents, while
            Put inserts an element. This is a very important difference. }

          WriteLn ('We have two identical tElement instances:');

          with CreateIterator^ do begin

               while not IsEnd do begin

                     { Use some selector methods
                       in tIterator to access the
                       tElement instance and its contents. }

                     Write ('[', Position, '] ');
                     Write (String(Content^), ' ');
                     if MyElement = Element
                        then Write ('(our initial element)')
                        else Write ('(a new element - created by the ADT)');
                     WriteLn;

                     WalkForward;
               end;

               Free; { Iterator }

          end;

          Free; { MyADT }

     end;
end.