/* eltime.c - use BIOS time-of-day interrupt */

#include <stdio.h>
#include <dos.h>

static long     STime;			/* store time-of-day from last call */

#define TOD_INT  0x1A			/* BIOS time-of-day interrupt */

 long
ElapsedTime (void) {								/* count ticks since last call */
	union REGS DReg;

	long            ElapsedTime, Delta;

	DReg.x.ax = 0;							/* get time count */
	int86(TOD_INT, &DReg, &DReg);			/* get current  count */

	/* assemble 32-bit time-of-day value */

	ElapsedTime = (((long) DReg.x.cx) << 16) + (unsigned) DReg.x.dx;
	Delta = ElapsedTime - STime;

	/* check for new day since last call */

	if (((DReg.x.ax & 0xFF) != 0) || (Delta < 0))
		Delta = Delta + 0x01800B0L;			/* new day - add 1 day in ticks */
	STime = ElapsedTime; 					/* save time-of-day for next call */
	return (Delta);							/* return as an integer */
	}
