//===================================================================
// algorthm.hpp
//
// Version 1.1
//
// Written by:
//   Brent Worden
//   WordenWare
//   email:  Brent@Worden.org
//
// Copyright (c) 1998-1999 WordenWare
//
// Created:  August 28, 1998
// Revised:  April 10, 1999
//===================================================================

#include <iostream>

#include "numerror.h"

NUM_BEGIN

NUMERICS_EXPORT void NUMERICS_ERROR(const char *func, const char *msg)
{
	std::cerr << "Numerics Error in routine " << func << std::endl;
	std::cerr << "    " << msg << std::endl;
}

NUM_END

//===================================================================
// Revision History
//
// Version 1.0 - 08/28/1998 - New.
// Version 1.1 - 04/10/1999 - Added Numerics namespace.
//                            Added std scope resolution.
//===================================================================
