// File from page 783 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT02.ZIP 4/11/95
// (Original ECKELT01.ZIP dated 2/21/95)
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: SSHAPE.CPP -- "Virtual constructors"
// Used in a simple "shape" framework
#include <iostream.h>
#include "..\14\tstash.h"

class shape {
  shape* S;
  // Prevent copy-construction & operator=
  shape(shape&);
  shape operator=(shape&);
protected:
  shape() { S = 0; };
public:
  enum type { Circle, Square, Triangle };
  shape(type);  // "Virtual" constructor
  virtual void draw() { S->draw(); }
  virtual ~shape() {
    cout << "~shape\n";
    delete S;
  }
};

class circle : public shape {
  // Prevent copy-construction & operator=
  circle(circle&);
  circle operator=(circle&);
public:
  circle() {}
  void draw() { cout << "circle::draw\n"; }
  ~circle() { cout << "~circle\n"; }
};

class square : public shape {
  // Prevent copy-construction & operator=
  square(square&);
  square operator=(square&);
public:
  square() {}
  void draw() { cout << "square::draw\n"; }
  ~square() { cout << "~square\n"; }
};

class triangle : public shape {
  // Prevent copy-construction & operator=
  triangle(triangle&);
  triangle operator=(triangle&);
public:
  triangle() {}
  void draw() { cout << "triangle::draw\n"; }
  ~triangle() { cout << "~triangle\n"; }
};

shape::shape(type t) {
  switch(t) {
    case Circle: S = new circle; break;
    case Square: S = new square; break;
    case Triangle: S = new triangle; break;
  }
  draw();  // Virtual call in the constructor
}

main() {
  tstash<shape> shapes; // Default to ownership
  cout << "virtual constructor calls:" << endl;
  shapes.add(new shape(shape::Circle));
  shapes.add(new shape(shape::Square));
  shapes.add(new shape(shape::Triangle));
  cout << "virtual function calls:" << endl;
  for(int i = 0; i < shapes.count(); i++)
    shapes[i]->draw();
  shape c(shape::Circle); // Can create on stack
}
