// File from page 424 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT02.ZIP 4/11/95
// (Original ECKELT01.ZIP dated 2/21/95)
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: SMARTP.CPP -- Smart pointer example
#include <iostream.h>
#include <string.h>

class obj {
  static int i, j;
public:
  void f() { cout << i++ << endl; }
  void g() { cout << j++ << endl; }
};

// Static member definitions:
int obj::i = 47;
int obj::j = 11;

// Container:
class obj_container {
  enum { sz = 100 };
  obj* a[sz];
  int index;
public:
  obj_container() {
    index = 0;
    memset(a, 0, sz * sizeof(obj*));
  }
  void add(obj* OBJ) {
    if(index >= sz) return;
    a[index++] = OBJ;
  }
  friend class sp;
};

// Iterator:
class sp {
  obj_container* oc;
  int index;
public:
  sp(obj_container* OC) {
    index = 0;
    oc = OC;
  }
  // Return value indicates end of list:
  int operator++() { // Prefix
    if(index >= oc->sz) return 0;
    if(oc->a[++index] == 0) return 0;
    return 1;
  }
  int operator++(int) { // Postfix
    return operator++(); // Use prefix version
  }
  obj* operator->() const {
    if(oc->a[index]) return oc->a[index];
    static obj dummy;
    return &dummy;
  }
};

main() {
  const sz = 10;
  obj o[sz];
  obj_container OC;
  for(int i = 0; i < sz; i++)
    OC.add(&o[i]); // Fill it up
  sp SP(&OC); // Create an iterator
  do {
    SP->f(); // Smart pointer calls
    SP->g();
  } while(SP++);
}
