/*
==============================================================================
		      WordUp Graphics Toolkit Version 5.0                     
			     Demonstration Program 57                         
									      
  This program uses the scrolling library to demonstrate some of the          
  possible configurations of the scrolling windows.                           
									      
  *** PROJECT ***                                                             
  This program requires the files WGT5_WC.LIB and WSCR_WC.LIB to be linked.   
									      
  *** DATA FILES ***                                                          
  TEST1-TEST4.SPR, TEST1-TEST4.WMP         
							   WATCOM C++ VERSION 
==============================================================================
*/

#include <dos.h>
#include <wgt5.h>
#include <wgtscrol.h>


/* Keyboard control codes */
#define LEFT 75
#define RIGHT 77
#define UP 72
#define DOWN 80
#define ESC 1

#define NUM_TILES 5

block tiles0[NUM_TILES+1];      /* 4 block array to hold our sets of tiles */
block tiles1[NUM_TILES+1];
block tiles2[NUM_TILES+1];
block tiles3[NUM_TILES+1];

short tiletypes0[256];            /* Tile types for each window */
short tiletypes1[256];
short tiletypes2[256];
short tiletypes3[256];

scrollsprite wobject[5];        /* No objects are used in this demo, but a
				   scrollsprite structure is needed to load
				   the map. */

short window_on[4];
block sprites[5];
wgtmap map0, map1, map2, map3;

short setup;

short oldmode;             /* Previous graphics mode */
color pal[256];            /* A common palette for all sprites/tiles */
short xsize[4], ysize[4];  /* The size of the tiles in our map */
char c;
int timer;
short movex, movey;

void loadsprites (void);
void loadmaps (void);
void find_tile_sizes (void);
void start_scroll (void);
void close_files (void);


void timerctr (void)
{
  timer++;
}


void main (void)
{
 int frames = 0;

 oldmode = wgetmode ();

 printf ("WGT v5.0  Scrolling Possibilities Demo\n");
 printf ("This demo is meant to show the versatility of WGT's scrolling\n");
 printf ("library.  It does not show all of the possible scrolling combinations\n");
 printf ("but it gives you some setups that you can base a game around.\n\n");
 printf ("The WGT v5.0 for Watcom system allows up to 50 maps used in any\n");
 printf ("combination of normal and parallax layers. This demo does not\n");
 printf ("make any attempt to illustrate these possibilities (or artwork :)\n\n");
 printf ("Choose your scrolling setup:\n\n");
 printf ("[0] 4 windows\n");
 printf ("[1] 1 window, 1 scrolling level\n");
 printf ("[2] 1 window, 2 scrolling levels\n");
 printf ("[3] 1 window, 3 scrolling levels\n");
 printf ("[4] 1 window, 4 scrolling levels\n");
 printf ("[5] 2 windows, 1 scrolling level, vertical\n");
 printf ("[6] 2 windows, 2 scrolling levels, vertical\n");
 printf ("[7] 2 windows, 1 scrolling level, horizontal\n");
 printf ("[8] 2 windows, 2 scrolling levels, horizontal\n");
 printf ("[9] 2 windows, 1 with 3 levels, the other with 1 level\n");

 printf ("Enter your setup:");
 scanf ("%i", &setup);

 vga256 ();

 loadsprites ();
 find_tile_sizes ();

 start_scroll ();
 loadmaps ();

 installkbd ();
 timer = 0;
 winittimer ();
 wstarttimer (timerctr, TICKS(100));
 do {
   movex = 0;
   movey = 0;

   if (kbdon[UP]) 
       movey = -16;
   if (kbdon[DOWN])
       movey = 16;
   if (kbdon[LEFT])
       movex = -16;
   if (kbdon[RIGHT])
       movex = 16;

   if (window_on[0])
       wscrollwindow (0, movex * 1 / 4, movey * 1 / 4);
   if (window_on[1])
       wscrollwindow (1, movex * 2 / 4, movey * 2 / 4);
   if (window_on[2])
       wscrollwindow (2, movex * 3 / 4, movey * 3 / 4);
   if (window_on[3])
       wscrollwindow (3, movex, movey);

//   wretrace ();
   switch (setup)
   {
     case 0: wputblock (0, 0, scrollblock[0], NORMAL);
	     wputblock (128, 0, scrollblock[1], NORMAL);
	     wputblock (0, 100, scrollblock[2], NORMAL);
	     wputblock (128, 100, scrollblock[3], NORMAL);
	     break;
     case 1:
     case 2:
     case 3:
     case 4: wputblock (0, 0, scrollblock[0], NORMAL); 
	     break;
     case 5:
     case 6: wputblock (0, 0, scrollblock[0], NORMAL);
	     wputblock (128, 0, scrollblock[1], NORMAL); 
	     break;
     case 7:
     case 8: wputblock (0, 0, scrollblock[0], NORMAL);
	     wputblock (0, 100, scrollblock[1], NORMAL); 
	     break;
     case 9: wputblock (0, 0, scrollblock[0], NORMAL);
	     wputblock (128, 0, scrollblock[3], NORMAL); 
	     break;
    }
    frames++;
  } while (!kbdon[ESC]);  /* Until ESC is hit */
  wstoptimer ();
  wdonetimer ();
  uninstallkbd ();
  close_files ();

  wsetmode (oldmode);
  printf ("Number of Frames: %i\n", frames);
  printf ("Time elapsed:     %7.2f seconds\n", (float)(timer) / 100.0);
  printf ("Frame Rate:       %f\n", (float)frames / ((float)(timer) / 100.0));
}


void loadsprites (void)
{
  wloadsprites (pal, "test1.spr", tiles0, 1, NUM_TILES);
  wloadsprites (pal, "test2.spr", tiles1, 1, NUM_TILES);
  wloadsprites (pal, "test3.spr", tiles2, 1, NUM_TILES);
  wloadsprites (pal, "test4.spr", tiles3, 1, NUM_TILES);
  wsetpalette (0, 255, pal);
}


void loadmaps (void)
{
  map0 = wloadmap (0, "test4.wmp", tiletypes0, wobject);
  map1 = wloadmap (1, "test3.wmp", tiletypes1, wobject);
  map2 = wloadmap (2, "test2.wmp", tiletypes2, wobject);
  map3 = wloadmap (3, "test1.wmp", tiletypes3, wobject);

  /* If the tilewidth is not 0, the window must have been initialized
     above, so start viewing it at the top left of the map. */
  if (tilewidth[0] > 0)
  {
    wshowwindow (0, 0, 0);
    window_on[0] = 1;
  }
  if (tilewidth[1] > 0)
  {
    wshowwindow (1, 0, 0);
    window_on[1] = 1;
  }
  if (tilewidth[2] > 0)
  {
    wshowwindow (2, 0, 0);
    window_on[2] = 1;
  }
  if (tilewidth[3] > 0)
  {
    wshowwindow (3, 0, 0);
    window_on[3] = 1;
  }
}
  

void find_tile_sizes (void)
{
  xsize[0] = wgetblockwidth (tiles0[1]);
  ysize[0] = wgetblockheight (tiles0[1]);

  xsize[1] = wgetblockwidth (tiles1[2]);
  ysize[1] = wgetblockheight (tiles1[2]);

  xsize[2] = wgetblockwidth (tiles2[1]);
  ysize[2] = wgetblockheight (tiles2[1]);

  xsize[3] = wgetblockwidth (tiles3[1]);
  ysize[3] = wgetblockheight (tiles3[1]);
}


void start_scroll (void)
{
  switch (setup)
  {
    case 0:  winitscroll (0, NORMAL,  -1, 128 / xsize[2], 96 / ysize[2], tiles2);
	     winitscroll (1, NORMAL,  -1, 128 / xsize[1], 96 / ysize[1], tiles1);
	     winitscroll (2, NORMAL,  -1, 128 / xsize[2], 96 / ysize[2], tiles2);
	     winitscroll (3, NORMAL,  -1, 128 / xsize[3], 96 / ysize[3], tiles3); break;
    case 1:  winitscroll (0, NORMAL,  -1, 320 / xsize[3], 192 / ysize[3], tiles3); break;
    case 2:  winitscroll (0, NORMAL,  -1, 320 / xsize[3], 192 / ysize[3], tiles3);
	     winitscroll (1, PARALLAX, 0, 320 / xsize[1], 192 / ysize[1], tiles1); break;
    case 3:  winitscroll (0, NORMAL,  -1, 256 / xsize[0], 192 / ysize[0], tiles0);
	     winitscroll (1, PARALLAX, 0, 256 / xsize[1], 192 / ysize[1], tiles1);
	     winitscroll (2, PARALLAX, 0, 256 / xsize[2], 192 / ysize[2], tiles2); break;
    case 4:  winitscroll (0, NORMAL,  -1, 256 / xsize[0], 192 / ysize[0], tiles0);
	     winitscroll (1, PARALLAX, 0, 256 / xsize[2], 192 / ysize[2], tiles2);
	     winitscroll (2, PARALLAX, 0, 256 / xsize[1], 192 / ysize[1], tiles1);
	     winitscroll (3, PARALLAX, 0, 256 / xsize[3], 192 / ysize[3], tiles3); break;
    case 5:  winitscroll (0, NORMAL,  -1, 128 / xsize[0], 192 / ysize[0], tiles0);
	     winitscroll (1, NORMAL,  -1, 128 / xsize[1], 192 / ysize[1], tiles1); break;
    case 6:  winitscroll (0, NORMAL,  -1, 128 / xsize[0], 192 / ysize[0], tiles0);
	     winitscroll (1, NORMAL,  -1, 128 / xsize[1], 192 / ysize[1], tiles1);
	     winitscroll (2, PARALLAX, 0, 128 / xsize[2], 192 / ysize[2], tiles2);
	     winitscroll (3, PARALLAX, 1, 128 / xsize[3], 192 / ysize[3], tiles3); break;
    case 7:  winitscroll (0, NORMAL,  -1, 320 / xsize[2], 96 / ysize[2], tiles2);
	     winitscroll (1, NORMAL,  -1, 320 / xsize[1], 96 / ysize[1], tiles1); break;
    case 8:  winitscroll (0, NORMAL,  -1, 320 / xsize[2], 96 / ysize[2], tiles2);
	     winitscroll (1, NORMAL,  -1, 320 / xsize[1], 96 / ysize[1], tiles1);
	     winitscroll (2, PARALLAX, 0, 320 / xsize[2], 96 / ysize[2], tiles2);
	     winitscroll (3, PARALLAX, 1, 320 / xsize[3], 96 / ysize[3], tiles3); break;
    case 9:  winitscroll (0, NORMAL,  -1, 128 / xsize[2], 192 / ysize[2], tiles2);
	     winitscroll (1, PARALLAX, 0, 128 / xsize[1], 192 / ysize[1], tiles1);
	     winitscroll (2, PARALLAX, 0, 128 / xsize[3], 192 / ysize[3], tiles3);
	     winitscroll (3, NORMAL,  -1, 128 / xsize[3], 192 / ysize[3], tiles3); break;
  }                                                                      
}


void close_files(void)
{
  wfreemap (map0);
  wfreemap (map1);
  wfreemap (map2);
  wfreemap (map3);
  wendscroll (0);
  wendscroll (1);
  wendscroll (2);
  wendscroll (3);
}


