/* yd_dot.h                     freeware                   xhunga@tiscali.fr  */


/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
fraction innerprod_Mnm(
pmatrix mU,
pmatrix mV
)
{
fraction InnerProduct;

double pTrposU   [MXR][MXC*TWOCOL];matrix mTrposU   ={MXR,MXC*TWOCOL,&pTrposU   [0][0]};
double pTrposU_V [MXR][MXC*TWOCOL];matrix mTrposU_V ={MXR,MXC*TWOCOL,&pTrposU_V [0][0]};

             mTrposU.rows =   mU->cols/2;       mTrposU.cols = mU->rows*TWOCOL;
           mTrposU_V.rows = mTrposU.rows;     mTrposU_V.cols = mV->cols;

            transposemF(mU,&mTrposU);
                 multmF(   &mTrposU,mV,&mTrposU_V);
  InnerProduct= tracemF(               &mTrposU_V);

 return(InnerProduct);
}

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
fraction norm_MnmP2(
pmatrix mu
)
{
fraction NormP2;

         NormP2 = innerprod_Mnm(mu,mu);

  return(NormP2);
}

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
fraction distance_MnmP2(
pmatrix mu,
pmatrix mv
)
{
fraction DistanceP2;

double pu_mns_v [MXR][MXC*TWOCOL];
matrix mu_mns_v={MXR, MXC*TWOCOL,&pu_mns_v[0][0]};

       mu_mns_v.rows = mu->rows;
       mu_mns_v.cols = mu->cols;

      submF(mu,mv,&mu_mns_v);

  DistanceP2 = norm_MnmP2(&mu_mns_v);

  return(DistanceP2);
}



/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void projwn_Mnm(
pmatrix mu,
pmatrix mv,
pmatrix mvn
)
{
fraction InnerProduv;
fraction     NormvP2;
fraction   InvNormP2;
fraction InnerProduv_InvNormP2;
/*-------------------------------- PROGRAM ---------------------------------- */
             InnerProduv = innerprod_Mnm(mu,mv);

                 NormvP2 =    norm_MnmP2(   mv);
               InvNormP2 =      invF(NormvP2);
   InnerProduv_InvNormP2 =  multF(InnerProduv,InvNormP2);

        smultmF(InnerProduv_InvNormP2,mv,mvn);
}
