/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
gjA(int n)
{
fraction det;

double pbA     [MXR][MXC*TWOCOL];matrix mA      ={MXR,MXC*TWOCOL,&pbA     [0][0]};
double pbb     [MXR][MXC*TWOCOL];matrix mb      ={MXR,MXC*TWOCOL,&pbb     [0][0]};
double pbxT    [MXR][MXC*TWOCOL];matrix mxT     ={MXR,MXC*TWOCOL,&pbxT    [0][0]};
double pTrpsA  [MXR][MXC*TWOCOL];matrix mTrpsA  ={MXR,MXC*TWOCOL,&pTrpsA  [0][0]};
double pTrpsA_A[MXR][MXC*TWOCOL];matrix mTrpsA_A={MXR,MXC*TWOCOL,&pTrpsA_A[0][0]};


                     mA.rows= n;             mA.cols=(n-1)*TWOCOL;
                     mb.rows= n;             mb.cols=      TWOCOL;
                    mxT.rows=(n-1);         mxT.cols=      TWOCOL;
                 mTrpsA.rows=(n-1);      mTrpsA.cols= n   *TWOCOL;
               mTrpsA_A.rows=(n-1);    mTrpsA_A.cols=(n-1)*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  do
  {
         rndmF(&mA,3,1);
   transposemF(&mA,&mTrpsA);
        multmF(    &mTrpsA,&mA,&mTrpsA_A);

          det = detF(&mTrpsA_A);
  }while(!det.numer);

  rndmF(&mb,3,2);

  clrscrn();
  printf(" Find the least squares solution of the linear system Ax = b\n\n");
  printf("                                                       A      :");
  printmF(&mA);
  printf("                                                            b :");
  printmF(&mb);
  getchar();

  printf("\n\n the least squares solution of the linear system Ax = b :\n");
  leastsqrs(&mA,&mb,&mxT);
  printmF(          &mxT);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n\n            Ax = b                          \n\n");
  printf("          A is an mxn matrix,                     \n");
  printf("  with linearly independent column vectors,     \n\n");
  printf("   Find the least squares solution                \n");
  printf("     of the linear system Ax = b                  \n");
  printf("     ***************************                  \n");
  printf("\n\n\n\n\n\n\n                                      ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                         ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {  n = rndpI(4);}
if( n < 3){n=3;}


  gjA(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

