	page 60,132
	title	GetValidChoice - Get Validated User Choice
	name	GetValidChoice
	
comment 
	GetValidChoice						V1.00
----------------------------------------------------------------------------
NAME
	GetValidChoice				Get Validated User Choice

SYNOPSIS
	mov	ax, Choices		; AH = ret w/ carry flag set
					; AL = ret w/ carry flag clear
	call	GetValidChoice

DESCRIPTION
	This procedure is called after a message is displayed to which the
	user has two choices with which to respond.  These valid choices
	must be passed to the procedure in lower case in the AX register.

	This procedure waits for the user response.  If the user enters
	the choice in the AH register, this procedure returns with the
	Carry Flag set.	 If the user enters the choice in the AL register,
	this procedure returns with the Carry Flag clear.  If the user
	enters an invalid character, this procedure builds a message in
	the form "? (x/y): " where x and y are the AH and AL register
	choices respectively.	This procedure waits for another response.

	The user may respond in either case.

PROGRAMMING NOTES

	Written to be assembled in any memory model with small as the
	default.

	Procedures called:
		None
	DOS Interrupts
		Int 21h 40h - Write to file or device
		Int 21h 0ch - Clear input buffer and wait
		Int 21h 01h - Read Keyboard with Echo

CAUTIONS
	If selections are combined into a
		mov	ax, Choices
	say for "(y/n)" the values in the initializer must be reverse to
		mov	ax, "ny"
RETURNS
	Carry Flag is set if AH choice is entered by user.
	Carry Flag is clear if AL choice is entered by user.

MEMORY REQUIREMENTS
	Model:	 Tiny/Small/Compact	Medium/Large/Huge
	Stack:	  6 bytes		 8 bytes
	Data:	  9 bytes		 9 bytes
	Code:	 55 bytes		55 bytes

	All data is kept in DGROUP.

AUTHOR
	Raymond Moon - 5 Mar 95
	Copyright (c) 1995, 1997 MoonWare ShareWare
	ALL RIGHTS RESERVED

HISTORY
	Version	- Date		- Remarks
	1.00	-  5 Mar 95	- Original
	1.01	- 19 Oct 97	- Updated Copyright
	
	 End of Comment

;----------------------------
;	Make the small memory model the default.

ifndef	memmod
memmod	equ	<small>
endif

	include procesor.inc

%	.MODEL	memmod,FORTRAN
	assume	es:DGROUP

;-----------------------------
;	Include files

	include stderrf.inc

;----------------------------
;	Required Stuctures

QUERY_S struc
qsOpen	db	"? ("
qsFirst db	?
qsSep	db	'/'
qsSec	db	?
qsClose db	"): "
QUERY_S ends

;=========================================================================
;	DATA
;=========================================================================
	.DATA

QUERY	QUERY_S <>

;=========================================================================
;	CODE segment
;=========================================================================

	.CODE

GetValidChoice	proc
local	Choices:word			; Automatic storage for Choices

;----------------------------
;	Save Choices for use later

	mov	Choices, ax

;----------------------------
;	Build Query

	mov	QUERY.qsFirst, al	; Save CF clear choice
	mov	QUERY.qsSec, ah 	; Save CF set choice

;----------------------------
;	Get the user response

GR1:	mov	ax, 0c01h		; Clear buffer and wait for response
					;   with echo
	int	21h			; Call DOS

;-----------------------------
;	Process the response

	mov	bx, Choices		; BX = Choices
	or	al, 20h			; convert to lower case
	cmp	al, bl			; Is it CF clear choice?
	je	GR2			; Yes, go to clc code
	cmp	al, bh			; Is it CF set choice?
	jne	GR4			; No, invalid response
	stc				; Yes, set Carry Flay
	jmp	GR3			; Go to return
GR2:	clc				; Clear Carry Flag
GR3:	ret				; Return

;----------------------------
;	Display query and start again

GR4:	@WRITE	QUERY, STDERR
	jmp	GR1

GetValidChoice	endp
	end
