/*
    Copyright (C) 2000 Andrew Zabolotny <bit@eltech.ru>

    Usage of this library is not restricted in any way.
    The full license text can be found in the file dxe.txt.

    Sample DXE module -- with unresolved external symbols.
    This DXE module uses several external symbols.
    These symbols are left unresolved and are resolved at the load time.

    Also here we have a example of constructors and destructors, which
    are called automatically at library load/unload time.
*/

#include <stdio.h>

extern "C" extern_func ();
extern "C" extern_func_2 ();

extern "C" int test_func ()
{
  extern_func ();
  extern_func_2 ();
  printf ("hello world! (&extern_func = %p)\n", &extern_func);
  return 0;
}

int x_counter = 0;

extern "C" int doit ()
{
  return ++x_counter;
}

class TestClass
{
public:
  TestClass ()
  {
    printf ("TestClass::TestClass ()\n");
  }
  ~TestClass ()
  {
    printf ("TestClass::~TestClass ()\n");
  }
} test_object;
